        </script>
        <script>
            var migratorLogApp = angular.module('migratorLogApp', []);

            migratorLogApp.controller('migratorLogCtrl', function ($scope) {
            	// Take data from log information JSON to controller
                $scope.log_items = log.items;
                $scope.errorsCount = log.errorsCount;
                $scope.warningsCount = log.warningsCount;
                $scope.threads = log.threads;

				// Display options
                $scope.displayTime = false;
                $scope.displayContext = false;
                $scope.displayThread = false;
                $scope.displayDebugMessages = true;
                $scope.threadsSelect = $scope.threads; // All threads selected by default


				// Function to filter log items according to display options
                $scope.filterThreads = function(item) {
                    return $scope.threadsSelect.indexOf(item.thread) != -1;
                };
                $scope.filterDebug = function(item) {
                    return $scope.displayDebugMessages || item.level != "D";
                };
				$scope.filterLogItem = function(item) {
					return $scope.filterThreads(item) && $scope.filterDebug(item);
				}

				// Expand all log items
                $scope.expandAllLogItems = function() {
                    angular.forEach($scope.log_items, function(top_level_item) {
                        top_level_item.expand = true;
                        angular.forEach(top_level_item.items, function(item) {
                            item.expand = true;
                        })
                    });
                };

                // Collapse all log items
                $scope.collapseAllLogItems = function() {
                    angular.forEach($scope.log_items, function(top_level_item) {
                        top_level_item.expand = false;
                        angular.forEach(top_level_item.items, function(item) {
                            item.expand = false;
                        })
                    });
                };

                // Human-readable thread title
                // ("Main thread" instead of "MT", "Subscription thread #4" instead of "ST4")
                $scope.threadTitle = function(thread) {
                    if (thread == "MT") {
                        return "Main thread";
                    } else {
                        return "Subscription thread #" + thread.replace(/[^\d]/g, ''); ;
                    }
                }

           		// CSS class for coloring different levels of log item:
				// errors should be displayed with red, warnings with yellow, and so on.
				// Also, consider if any child item is an error or warning,
				// so we could easily see errors and warnings at top level, with no need to expand
				// all items.
                $scope.logLevelCssClass = function(item) {
                    if (item.level == "E" || item.has_errors) { // ERROR
                        return "bg-danger";
                    } else if (item.level == "W" || item.has_warnings) { // WARNING
                        return "bg-warning";
                    } else if (item.level == "I") { // INFO
                        return "bg-success";
                    } else if (item.level == "S") { // Migration start
                        return "bg-primary";
                   	} else { // DEBUG and all others
                        return "bg-info";
                    }
                };

				// CSS class for expand/collapse actions:
				// if log item could be expanded/collapsed, we should display it in other style,
				// for example display pointer cursor when mouse is over that link.
                $scope.expandableItemCssClass = function(item) {
                    if (item.items.length == 0 && item.message_other_lines.length == 0) {
                        return "";
                    } else {
                        return "expandable";
                    }
                }

				// Expand sign, displayed before the log item.
				// Could be:
				// "+" (log item could be expanded),
				// "-" (log item could be collapsed),
				// " " (one space, means log item has no child items, and only single line of text).
                $scope.expandSign = function(item) {
                    if (item.items.length == 0 && item.message_other_lines.length == 0) {
                        return " ";
                    } else {
                        if (item.expand) {
                            return "-";
                        } else {
                            return "+";
                        }
                    }
                }

				// Toggle expand state of a log item. If it was expanded - collapse it,
				// if it was collapsed - expand it.
                $scope.toggleExpand= function(item) {
                    item.expand = !item.expand;
                }
            });
        </script>
        <style>
            #log_items {
                font-family: monospace;
                padding: 30px;
            }
            .expandable {
                font-weight: bold;
                cursor: pointer;
            }
            .indent {
            	padding-left: 40px;
            }
            .pre {
            	white-space: pre;
            }
        </style>
        <title>Migrator debug log</title>
    </head>
    <body ng-controller="migratorLogCtrl">

    	<!-- Controls to set log parameters -->
        <div class="container-fluid">
        	<!-- Filter configuration -->
            <div class="col-md-4">
                <h3>Filter configuration</h3>
                <div class="col-md-6">
                    <h4>Fields</h4>
                    <div>
                        <input type="checkbox" ng-model="displayTime"> Display time
                    </div>
                    <div>
                        <input type="checkbox" ng-model="displayContext"> Display context information
                    </div>
                    <div>
                        <input type="checkbox" ng-model="displayThread"> Display thread
                    </div>
                    <h4>Log items</h4>
                    <div>
                        <input type="checkbox" ng-model="displayDebugMessages"> Display debug messages
                    </div>
                </div>
                <div class="col-md-6">
                    <h4>Threads</h4>
                    <div>
                        <select name="threadsSelect" id="threadsSelect" ng-model="threadsSelect" multiple>
                            <option ng-repeat="thread in threads" value="{{thread}}">{{threadTitle(thread)}}</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Expand/collapse buttons -->
            <div class="col-md-4">
                <h3>Expand/collapse</h3>
                <div>
                	<div>
                		<button type="button" class="btn btn-default" ng-click="expandAllLogItems()">Expand all</button>
                	</div>
                	<div>
                		Use this button carefully. If the log is large, it could take long time for browser
                		to expand and render all log items.
                	</div>
                </div>
                <div>
                	<button type="button" class="btn btn-default" ng-click="collapseAllLogItems()">Collapse all</button>
                </div>
            </div>

            <!-- Various log information -->
            <div class="col-md-4">
                <h3>Log information</h3>
                <div>Errors: {{errorsCount}}</div>
                <div>Warnings: {{warningsCount}}</div>
            </div>
        </div>
        <hr/>

        <!-- Log items -->
        <div id="log_items">
            <div ng-repeat="top_level_item in log_items | filter:filterLogItem">
            	<!-- Top-level log item itself. Top-level item is an item at INFO level, or migration start item -->
                <div class="{{logLevelCssClass(top_level_item)}}">

                	<!-- The first line of the log item, with time, context and thread information. Always show. -->
                	<span class="{{expandableItemCssClass(top_level_item)}}" ng-click="toggleExpand(top_level_item)">
                    	<span>[{{expandSign(top_level_item)}}]&nbsp;</span>
                    	<span ng-if="displayTime">[{{top_level_item.time}}]&nbsp;</span>
                    	<span ng-if="displayContext">[{{top_level_item.context}}]&nbsp;</span>
                    	<span ng-if="displayThread">[{{top_level_item.thread}}]&nbsp;</span>
                    	<span>{{top_level_item.message_first_line}}</span>
					</span>

					<!-- All the next lines of the log item: show only if it is expanded -->
                    <div
                    	ng-if="top_level_item.expand"
                    	ng-repeat="line in top_level_item.message_other_lines track by $index"
                    >
                        {{line}}
                    </div>

                </div>

                <!-- Second level log items. Show them only if top-level log item is expanded. -->
                <div ng-if="top_level_item.expand">
                    <div
                    	ng-repeat="second_level_item in top_level_item.items | filter:filterLogItem"
                    	class="indent"
                    >

                        <!-- The first line of the log item -->
						<span
							class="{{expandableItemCssClass(second_level_item)}}"
							ng-click="toggleExpand(second_level_item)"
						>
							<span>[{{expandSign(second_level_item)}}]&nbsp;</span>
							<span ng-if="displayTime">[{{second_level_item.time}}]&nbsp;</span>
							<span ng-if="displayContext">[{{second_level_item.context}}]&nbsp;</span>
							<span ng-if="displayThread">[{{second_level_item.thread}}]&nbsp;</span>
							<span class="{{logLevelCssClass(second_level_item)}} pre">{{second_level_item.message_first_line}}</span>
						</span>

						<!-- All the next lines of the second level item: show only if it is expanded -->
                        <div
                        	ng-if="second_level_item.expand"
                        	ng-repeat="line in second_level_item.message_other_lines track by $index"
                        	class="indent"
                        >
                            <span class="pre">{{line}}</span>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </body>
</html>
