from parallels.core.utils.common import if_not_none, parse_bool, is_not_none


class MailAccount(object):
    @classmethod
    def parse(cls, mail_user_node, domain_name):
        password_node = mail_user_node.find('properties/password')
        password = if_not_none(password_node, lambda node: node.text)
        password_type = if_not_none(password_node, lambda node: node.attrib.get('type'))

        is_enable_cp_access = parse_bool(mail_user_node.attrib.get('cp-access-default'), False)

        mail_box_node = mail_user_node.find('preferences/mailbox')
        is_enable_mailbox = is_not_none(mail_box_node, lambda node: parse_bool(node.attrib.get('enabled'), False))

        aliases = []
        for alias_node in mail_user_node.findall('preferences/alias'):
            aliases.append(alias_node.text)

        is_enable_forwarding = parse_bool(mail_user_node.attrib.get('forwarding-enabled'), False)
        forwarding_addresses = []
        for forwarding_node in mail_user_node.findall('preferences/forwarding'):
            forwarding_addresses.append(forwarding_node.text)

        return MailAccount(
            mail_user_name=mail_user_node.attrib['name'],
            domain_name=domain_name,
            password=password,
            password_type=password_type,
            is_enable_cp_access=is_enable_cp_access,
            is_enable_mailbox=is_enable_mailbox,
            aliases=aliases,
            is_enable_forwarding=is_enable_forwarding,
            forwarding_addresses=forwarding_addresses
        )

    def __init__(
        self, mail_user_name, domain_name, password, password_type, is_enable_cp_access, is_enable_mailbox, aliases,
        is_enable_forwarding, forwarding_addresses
    ):
        self.mail_user_name = mail_user_name
        self.domain_name = domain_name
        self.password = password
        self.password_type = password_type
        self.is_enable_cp_access = is_enable_cp_access
        self.is_enable_mailbox = is_enable_mailbox
        self.aliases = aliases
        self.is_enable_forwarding = is_enable_forwarding
        self.forwarding_addresses = forwarding_addresses

    @property
    def name(self):
        return '%s@%s' % (self.mail_user_name, self.domain_name)
