class ClientSubscriptionConverterAdapter(object):
    """Common interface for client and subscription converter adapter"""
    def convert(self, global_context, reseller_plans, hosting_plans, resellers, report):
        """Convert customers and subscriptions

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type reseller_plans: list[parallels.core.target_data_model.ResellerPlan]
        :type hosting_plans: dict[str|None, list[parallels.core.target_data_model.HostingPlan]]
        :type resellers: list[parallels.core.target_data_model.Reseller]
        :type report: parallels.core.reports.model.report.Report
        """
        raise NotImplementedError()
