from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties import LoggingProperties


class RemoveSSHKeys(CommonAction):
    def get_description(self):
        return messages.ACTION_REMOVE_TEMP_SSH_KEYS

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.FAILED_REMOVE_TEMPORARY_SSH_KEYS

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed, migration tool won't run the next operations.

        :rtype: bool
        """
        return False

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        global_context.ssh_key_pool.remove_all()

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user"""
        return LoggingProperties(info_log=False)
