from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.post_migration_checks.utils import should_run_post_migration_checks
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.hosting_check.reporting import print_backup_hosting_report


class PrintPostMigrationReportAction(CommonAction):
    def __init__(self, report_filename):
        """Class constructor

        :type report_filename: str | unicode
        """
        self._report_filename = report_filename

    def get_description(self):
        """Get short description of action as string

        :rtype: str | unicode
        """
        return messages.PRINT_POST_MIGRATION_REPORT_ACTION_DESCRIPTION

    def filter_action(self, global_context):
        """Check whether we should run this action or not. By default True - action should be executed.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: bool
        """
        return should_run_post_migration_checks(global_context)

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.PRINT_POST_MIGRATION_REPORT_ACTION_FAILURE

    def is_critical(self):
        """If action is critical or not

        :rtype: bool
        """
        return False

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user

        :rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
        """
        return LoggingProperties(info_log=False)

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        print_backup_hosting_report(
            global_context.post_migration_check_report,
            self._report_filename,
            exit_with_exit_code=True
        )
