from parallels.core import messages, MigrationNoContextError
import logging
import os

from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.migration_list.utils import get_migration_list_file_location
from parallels.core.actions.utils.logging_properties import LoggingProperties

logger = logging.getLogger(__name__)


class CheckMigrationListNotExistsForGeneration(CommonAction):
    def get_description(self):
        return messages.CHECK_IF_MIGRATION_LIST_FILE_ALREADY

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.FAILED_CHECK_IF_MIGRATION_LIST_FILE

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user

        :rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
        """
        return LoggingProperties(info_log=False)

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        migration_list_file = get_migration_list_file_location(global_context)

        if os.path.exists(migration_list_file):
            if not global_context.options.overwrite:
                raise MigrationNoContextError(
                    messages.MIGRATION_LIST_FILE_EXISTS % (migration_list_file,)
                )
            else:
                logger.info(
                    messages.MIGRATION_LIST_FILE_EXISTS_OVERWRITE,
                    migration_list_file
                )
