from parallels.core import messages
from parallels.core.registry import Registry
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties import LoggingProperties

import logging

logger = logging.getLogger(__name__)


class GetProgressAction(CommonAction):
    def get_description(self):
        return messages.ACTION_GET_PROGRESS

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_GET_PROGRESS_FAILED

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed, migration tool won't run the next operations.

        :rtype: bool
        """
        return True

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        progress = Registry.get_instance().get_context().progress
        progress.update()
        if Registry.get_instance().get_context().options.quiet:
            print(progress.get_serialized_data())
        else:
            data = progress.get_data()
            if data is not None:
                logger.info(messages.ACTION_GET_PROGRESS_DATA.format(
                    command=data['command'],
                    status=data['status']
                ))
            else:
                logger.info(messages.ACTION_GET_PROGRESS_NONE)

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user"""
        return LoggingProperties(info_log=False)