from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.reports.plain_report import PlainReport


class ComposeFinalMigrationReport(CommonAction):
    def get_description(self):
        """Get short description of action as string

        :rtype: str
        """
        return messages.ACTION_COMPOSE_FINAL_REPORT_DESCRIPTION

    def get_failure_message(self, global_context):
        """Get message for situation when action failed

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_COMPOSE_FINAL_REPORT_FAILURE

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user

        :rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
        """
        return LoggingProperties(info_log=False)

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        plain_report = PlainReport(
            global_context.migration_report_writer, global_context.migration_list_data
        )

        # merge pre-migration check tree into final report tree
        pre_check_plain_report = PlainReport(
            global_context.pre_check_report, global_context.migration_list_data
        )
        for subscription in global_context.iter_all_subscriptions():
            pre_check_subscription_report = pre_check_plain_report.get_subscription_report(subscription.name)
            subscription_report = plain_report.get_subscription_report(subscription.name)
            for issue in pre_check_subscription_report.issues:
                subscription_report.add_issue_obj(issue)
