from parallels.core.actions.base.common_action import CommonAction
from parallels.core.utils.common import is_empty_iterator


class ResellerAction(CommonAction):
    """Base class for actions performed on customers
    """

    def filter_action(self, global_context):
        return not is_empty_iterator(global_context.target_model.resellers)

    def run(self, global_context):
        for reseller in global_context.target_model.resellers.itervalues():
            with global_context.safe.try_reseller(
                reseller.login,
                self._get_reseller_failure_message(global_context, reseller)
            ):
                self._run_reseller(global_context, reseller)

    def _get_reseller_failure_message(self, global_context, reseller):
        """Retrieve error message if operation on specific customer failed

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type reseller: parallels.core.target_data_model.Reseller
        """
        raise NotImplementedError()

    def _run_reseller(self, global_context, reseller):
        """Run action on specific customer

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type reseller: parallels.core.target_data_model.Reseller
        """
        raise NotImplementedError()
