
class ActionPointer(object):
    """Dynamic pointer to an action

    Should be used to dynamically change/replace shared actions in workflow.
    """
    def __init__(self, action):
        self._action = action

    def resolve(self):
        """Resolve pointer to an action"""
        return self._action

    def set(self, action):
        """Set new action"""
        self._action = action
