Jsw.onReady(function() {
    // Update whole progress status control
    function updateProgressStatus(statusInfo) {
        updateProgressStatusElementsVisibility();
        updateProgressStatusCountElements(statusInfo);
        updateProgressStatusState(statusInfo);
    }

    // Update visibility of "add subscriptions" link and failed/success/warning count elements.
    // Visibility of these elements is specified by 2 global variables. It depends which are set according to the
    // current page.
    function updateProgressStatusElementsVisibility()
    {
        $$('.progress-status-count-box').each(function(element) {
            if (SHOW_STATUS_ICONS) {
                element.show();
            } else {
                element.hide();
            }
        });

        $$('.progress-status-add-subscriptions-link').each(function(element) {
            if (SHOW_ADD_SUBSCRIPTIONS_LINK) {
                element.show();
            } else {
                element.hide();
            }
        });
    }

    // Update number of failed/success/warning subscriptions, and visibility of corresponding elements:
    // they are not displayed if there are no subscriptions with corresponding status
    function updateProgressStatusCountElements(statusInfo)
    {
        $$('.progress-status-count-item-success').each(function(element) {
            if (statusInfo.queueFinishedSuccessSubscriptions > 0) {
                element.show();
            } else {
                element.hide();
            }
        });
        $$('.progress-status-count-item-failed').each(function(element) {
            if (statusInfo.queueFinishedFailedSubscriptions > 0) {
                element.show();
            } else {
                element.hide();
            }
        });
        $$('.progress-status-count-item-warning').each(function(element) {
            if (statusInfo.queueFinishedWarningSubscriptions > 0) {
                element.show();
            } else {
                element.hide();
            }
        });

        $$('.progress-status-count-value-success').each(function(element) {
            element.update(statusInfo.queueFinishedSuccessSubscriptions);
        });
        $$('.progress-status-count-value-failed').each(function(element) {
            element.update(statusInfo.queueFinishedFailedSubscriptions);
        });
        $$('.progress-status-count-value-warning').each(function(element) {
            element.update(statusInfo.queueFinishedWarningSubscriptions);
        });
    }

    // Update state and messages of progress status control: display one of four states:
    // 1) migration was not started yet
    // 2) migration is in progress right now: display progress bar
    // 3) migration finished for several (but not all) subscriptions
    // 4) migration finished for all subscriptions of the server
    function updateProgressStatusState(statusInfo)
    {
        var totalLeftSubscriptions = statusInfo.totalSourceSubscriptions - statusInfo.totalMigratedSubscriptions;

        if (statusInfo.overallStatus == 'finished-errors') {
            $('progress-status-not-started').hide();
            $('progress-status-in-progress').hide();
            $('progress-status-queue-finished').hide();
            $('progress-status-all-migrated').hide();
            $('progress-status-overall-failure').show();
            $('progress-status-text-overall-failure').update(statusInfo.overallErrorMessage);
        } else if (
            statusInfo.queueSubscriptions == 0 && statusInfo.totalMigratedSubscriptions == 0
        ) {
            $('progress-status-not-started').show();
            $('progress-status-in-progress').hide();
            $('progress-status-queue-finished').hide();
            $('progress-status-all-migrated').hide();
            $('progress-status-overall-failure').hide();
        } else if (
            statusInfo.queueSubscriptions > 0 &&
            statusInfo.queueFinishedSubscriptions < statusInfo.queueSubscriptions
        ) {
            $('progress-status-text-subscriptions-in-queue').update(
                formatMessage(
                    MESSAGE_SUBSCRIPTIONS_IN_QUEUE,
                    statusInfo.queueFinishedSubscriptions, statusInfo.queueSubscriptions
                )
            );
            var progressPercentage = Math.round(
                100 * statusInfo.queueFinishedSubscriptions / statusInfo.queueSubscriptions
            );
            $('progress-status-progress-bar').setStyle(
                {'width': progressPercentage + "%"}
            );
            $('progress-status-not-started').hide();
            $('progress-status-in-progress').show();
            $('progress-status-queue-finished').hide();
            $('progress-status-all-migrated').hide();
            $('progress-status-overall-failure').hide();
        } else if (statusInfo.totalMigratedSubscriptions < statusInfo.totalSourceSubscriptions) {
            $('progress-status-text-subscriptions-migrated').update(
                formatMessage(
                    MESSAGE_SUBSCRIPTIONS_MIGRATED, statusInfo.totalMigratedSubscriptions
                )
            );
            $('progress-status-text-subscriptions-not-migrated').update(
                formatMessage(
                    MESSAGE_SUBSCRIPTIONS_NOT_MIGRATED, totalLeftSubscriptions
                )
            );

            $('progress-status-not-started').hide();
            $('progress-status-in-progress').hide();
            $('progress-status-queue-finished').show();
            $('progress-status-all-migrated').hide();
            $('progress-status-overall-failure').hide();
        } else if (statusInfo.totalMigratedSubscriptions == statusInfo.totalSourceSubscriptions) {
            $('progress-status-text-all-subscriptions-migrated').update(
                formatMessage(
                    MESSAGE_ALL_SUBSCRIPTIONS_MIGRATED, statusInfo.totalMigratedSubscriptions
                )
            );

            $('progress-status-not-started').hide();
            $('progress-status-in-progress').hide();
            $('progress-status-queue-finished').hide();
            $('progress-status-all-migrated').show();
            $('progress-status-overall-failure').hide();
        } else {
            $('progress-status-not-started').hide();
            $('progress-status-in-progress').hide();
            $('progress-status-queue-finished').hide();
            $('progress-status-all-migrated').hide();
            $('progress-status-overall-failure').hide();
        }
    }

    function updateProgressStatusAjax()
    {
        new Ajax.Request(URL_GET_SESSION_STATUS, {
            onSuccess: function(response) {
                var json = response.responseText.evalJSON();
                updateProgressStatus(json);
                setTimeout(updateProgressStatusAjax, PROGRESS_STATUS_UPDATE_INTERVAL);
            }
        });
    }

    // Perform initial update from data passed in HTML
    updateProgressStatus(SESSION_STATUS);
    // Schedule run periodic updates with AJAX
    updateProgressStatusAjax();

    $('progress-status-cancel').observe('click', function() {
        showCancelAllPopup();
    });
});