
// Show popup dialog with settings to start DNS switching.
// Arguments:
// - subscriptions - list of subscription names.
// - onSuccess - function that will be called once DNS switch of these subscriptions is scheduled.
function showSwitchDNSPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_SWITCH_DNS_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_SWITCH_DNS_TITLE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    var popup = new Jsw.Popup({
        title: title,
        content: (
            '<div class="form-row">' +
                '<div>' + migratorLocale.lmsg('dnsSwitchDescription') + '</div>' +
                // TODO: implement support
                /*'<div class="field-name">' + MESSAGE_POPUP_SWITCH_DNS_BEFORE + '</div>' +
                '<div class="field-value">' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncBusinessObjects"> ' +
                        '<label for="resyncBusinessObjects">' +
                            MESSAGE_POPUP_SWITCH_DNS_RESYNC_BUSINESS_OBJECTS +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncFiles" checked="checked"> ' +
                        '<label for="resyncFiles">' +
                            MESSAGE_POPUP_SWITCH_DNS_RESYNC_FILES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncDatabases" checked="checked"> ' +
                        '<label for="resyncDatabases">' +
                            MESSAGE_POPUP_SWITCH_DNS_RESYNC_DATABASES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncMail" checked="checked"> ' +
                        '<label for="resyncMail">' +
                            MESSAGE_POPUP_SWITCH_DNS_RESYNC_MAIL +
                        '</label>' +
                    '</div>' +
                '</div>' + */
            '</div>'
        ),
        buttons: [
            {
                id: 'switchDnsOkButton',
                title: MESSAGE_POPUP_SWITCH_DNS_BUTTON_OK,
                class: 'action',
                handler: function(event, popup) {
                    // TODO: implement support
                    /*
                    var elemResyncBusinessObjects = $('resyncBusinessObjects');
                    var elemResyncFiles = $('resyncFiles');
                    var elemResyncDatabases = $('resyncDatabases');
                    var elemResyncMail = $('resyncMail');
                    */
                    disableButtonInProgress($('switchDnsOkButton'), 'schedulingButtonTitle');
                    disableButtonPlain($('switchDnsCancelButton'));

                    new Ajax.Request(URL_SWITCH_DNS_SUBSCRIPTIONS, {
                        parameters: {
                            subscriptions: Object.toJSON(subscriptions)
                            // TODO: implement support
                            /*
                            resyncBusinessObjects: elemResyncBusinessObjects.checked,
                            resyncFiles: elemResyncFiles.checked,
                            resyncDatabases: elemResyncDatabases.checked,
                            resyncMail: elemResyncMail.checked
                            */
                        },
                        onSuccess: function (response) {
                            if (onSuccess) {
                                onSuccess();
                            }
                            popup.hide();
                        }
                    });
                }
            },
            {
                id: 'switchDnsCancelButton',
                title: MESSAGE_POPUP_SWITCH_DNS_BUTTON_CANCEL,
                handler: function(event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();
}