
// Show popup dialog with settings to start re-sync of content (web, databases, mail).
// Arguments:
// - subscriptions - list of subscription names.
// - onSuccess - function that will be called once resync of these subscriptions is scheduled.
function showResyncPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_RESYNC_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_RESYNC_TITLE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    var popup = new Jsw.Popup({
        title: title,
        content: (
            '<div class="form-row">' +
                '<div class="field-name">' + MESSAGE_POPUP_RESYNC_CONTENT + '</div>' +
                '<div class="field-value">' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncBusinessObjects"> ' +
                        '<label for="resyncBusinessObjects">' +
                            MESSAGE_POPUP_RESYNC_BUSINESS_OBJECTS +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncFiles" checked="checked"> ' +
                        '<label for="resyncFiles">' +
                            MESSAGE_POPUP_RESYNC_FILES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncDatabases" checked="checked"> ' +
                        '<label for="resyncDatabases">' +
                            MESSAGE_POPUP_RESYNC_DATABASES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="resyncMail" checked="checked"> ' +
                        '<label for="resyncMail">' +
                            MESSAGE_POPUP_RESYNC_MAIL +
                        '</label>' +
                    '</div>' +
                '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'resyncOkButton',
                title: MESSAGE_POPUP_RESYNC_BUTTON_OK,
                class: 'action',
                handler: function(event, popup) {
                    var elemResyncBusinessObjects =  $('resyncBusinessObjects');
                    var elemResyncFiles = $('resyncFiles');
                    var elemResyncDatabases = $('resyncDatabases');
                    var elemResyncMail = $('resyncMail');

                    var someResyncChecked = (
                        elemResyncBusinessObjects.checked ||
                        elemResyncFiles.checked ||
                        elemResyncDatabases.checked ||
                        elemResyncMail.checked
                    );

                    if (someResyncChecked) {
                        disableButtonInProgress($('resyncOkButton'), 'schedulingButtonTitle');
                        disableButtonPlain($('resyncCancelButton'));

                        new Ajax.Request(URL_RESYNC_SUBSCRIPTIONS, {
                            parameters: {
                                subscriptions: Object.toJSON(subscriptions),
                                resyncBusinessObjects: elemResyncBusinessObjects.checked,
                                resyncFiles: elemResyncFiles.checked,
                                resyncDatabases: elemResyncDatabases.checked,
                                resyncMail: elemResyncMail.checked
                            },
                            onSuccess: function (response) {
                                if (onSuccess) {
                                    onSuccess();
                                }
                                popup.hide();
                            }
                        });
                    } else {
                        popup.hide();
                    }
                }
            },
            {
                id: 'resyncCancelButton',
                title: MESSAGE_POPUP_RESYNC_BUTTON_CANCEL,
                handler: function(event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();
}