
// Show popup dialog with confirmation to remove subscriptions from target server.
// Arguments: subscriptions - list of subscription names.
function showRemovePopup(subscriptions, onSuccess) {

    var RemoveMessageBox = Class.create(Jsw.MessageBox, {
        _defaultOnButtonClick: function() {}
    });

    var messageBox = new RemoveMessageBox({
        'type': Jsw.messageBox.TYPE_YESNO,
        'subtype': 'delete',
        'text': migratorLocale.lmsg('popupRemoveDescription'),
        'onYesClick': function () {
            this._componentElement.select('button').each(function(button) {
                button.disabled = true;
                button.up().addClassName('disabled');
            });
            this._componentElement.select('button').first().update(
                '<span class="wait">' + migratorLocale.lmsg('popupRemoveInProgress') + '</span>'
            );
            new Ajax.Request(URL_REMOVE_SUBSCRIPTIONS, {
                parameters: {
                    subscriptions: Object.toJSON(subscriptions)
                },
                onSuccess: function() {
                    messageBox.hide();
                    if (onSuccess) {
                        onSuccess();
                    }
                }
            });
        },
        'onNoClick': function () {
            this.hide();
        },
        'buttonTitles': {
            'yes': migratorLocale.lmsg('popupRemoveButtonYes'),
            'no': migratorLocale.lmsg('popupRemoveButtonNo')
        }
    });
    messageBox.show();
}
