
// Show popup dialog to reassign owner of subscriptions.
// Arguments: subscriptions - list of subscription names.
function showReassignOwnerPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_REASSIGN_OWNER_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_REASSIGN_OWNER_TITLE_MIGRATE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    var popup = new Jsw.Popup({
        title: title,
        content: (
            '<div class="form-row">' +
                '<div class="field-name">' + MESSAGE_POPUP_REASSIGN_OWNER_NAME + '</div>' +
                '<div class="field-value">' +
                    '<div id="reassign-input-container"></div>' +
                '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'reassignOwnerOkButton',
                title: MESSAGE_POPUP_REASSIGN_OWNER_BUTTON_OK,
                class: 'action',
                handler: function (event, popup) {
                    var elemReassignOwner =  $$('input[name="reassign-owner"]').first();
                    var ownerInfo = elemReassignOwner.value.evalJSON();
                    var ownerType = ownerInfo[0];
                    var ownerLogin = ownerInfo[1];

                    disableButtonInProgress($('reassignOwnerOkButton'), 'changingButtonTitle');
                    disableButtonPlain($('reassignOwnerCancelButton'));

                    new Ajax.Request(URL_REASSIGN_OWNER_SUBSCRIPTIONS, {
                        parameters: {
                            subscriptions: Object.toJSON(subscriptions),
                            ownerType: ownerType,
                            ownerLogin: ownerLogin
                        },
                        onSuccess: function (response) {
                            if (onSuccess) {
                                onSuccess();
                            }
                            popup.hide();
                        }
                    });
                }
            },
            {
                id: 'reassignOwnerCancelButton',
                title: MESSAGE_POPUP_REASSIGN_OWNER_BUTTON_CANCEL,
                handler: function (event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered migrator-popup-reassign'
    });

    popup.show();

    new Jsw.LookUp({
        id: 'reassign-owner',
        name: 'reassign-owner',
        renderTo: 'reassign-input-container',
        data: REASSIGN_OWNER_DATA,
        value: '',
        locale: REASSIGN_OWNER_LOCALE
    });
}