
// Show popup dialog with settings to start post-migration checks.
// Arguments:
// - subscriptions - list of subscription names.
// - onSuccess - function that will be called once post migration checks of these subscriptions is scheduled.
function showPostMigrationChecksPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_POST_MIGRATION_CHECKS_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_POST_MIGRATION_CHECKS_TITLE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    var popup = new Jsw.Popup({
        title: title,
        content: (
            '<div class="form-row">' +
                '<div class="field-name">' + MESSAGE_POPUP_POST_MIGRATION_CHECKS_WHAT + '</div>' +
                '<div class="field-value">' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="testSites" checked="checked"> ' +
                        '<label for="testSites">' +
                            MESSAGE_POPUP_POST_MIGRATION_CHECKS_SITES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="testMail" checked="checked"> ' +
                        '<label for="testMail">' +
                            MESSAGE_POPUP_POST_MIGRATION_CHECKS_MAIL +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="testDatabases" checked="checked"> ' +
                        '<label for="testDatabases">' +
                            MESSAGE_POPUP_POST_MIGRATION_CHECKS_DATABASES +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="testDNS" checked="checked"> ' +
                        '<label for="testDNS">' +
                            MESSAGE_POPUP_POST_MIGRATION_CHECKS_DNS +
                        '</label>' +
                    '</div>' +
                    '<div>' +
                        '<input type="checkbox" class="checkbox" id="testUsers" checked="checked"> ' +
                        '<label for="testUsers">' +
                            MESSAGE_POPUP_POST_MIGRATION_CHECKS_USERS +
                        '</label>' +
                    '</div>' +
                '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'postMigrationChecksOkButton',
                title: MESSAGE_POPUP_POST_MIGRATION_CHECKS_BUTTON_OK,
                class: 'action',
                handler: function(event, popup) {
                    var elemTestSites = $('testSites');
                    var elemTestMail = $('testMail');
                    var elemTestDatabases = $('testDatabases');
                    var elemTestDNS = $('testDNS');
                    var elemTestUsers = $('testUsers');

                    if (
                        !elemTestSites.checked &&
                        !elemTestMail.checked &&
                        !elemTestDatabases.checked &&
                        !elemTestDNS.checked &&
                        !elemTestUsers.checked
                    ) {
                        popup.hide();
                        return;
                    }

                    disableButtonInProgress($('postMigrationChecksOkButton'), 'schedulingButtonTitle');
                    disableButtonPlain($('postMigrationChecksCancelButton'));

                    new Ajax.Request(URL_POST_MIGRATION_CHECKS_SUBSCRIPTIONS, {
                        parameters: {
                            subscriptions: Object.toJSON(subscriptions),
                            testSites: elemTestSites.checked,
                            testMail: elemTestMail.checked,
                            testDatabases: elemTestDatabases.checked,
                            testDNS: elemTestDNS.checked,
                            testUsers: elemTestUsers.checked
                        },
                        onSuccess: function (response) {
                            if (onSuccess) {
                                onSuccess();
                            }
                            popup.hide();
                        }
                    });
                }
            },
            {
                id: 'postMigrationChecksCancelButton',
                title: MESSAGE_POPUP_POST_MIGRATION_CHECKS_BUTTON_CANCEL,
                handler: function(event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();
}