
function showFetchSourcePopup(session, onFinishedSuccess, onCloseWithErrors) {
    var error = null;
    var cancel = false;

    var popup = new Jsw.Popup({
        title: 'Preparing migration',
        content: (
            '<div style="margin-bottom: 10px;">' +
                '<span id="fetch-source-action-text">' +
                    migratorLocale.lmsg('fetchSourceStarting') +
                '</span>' +
                '<span id="fetch-source-error-text" style="display: none">' +
                '</span>' +
            '</div>' +
            '<div class="migrator-progress-bar" id="fetch-source-progress-bar">' +
                '<div class="migrator-progress-bar-wrap">' +
                    '<div style="width: 100%;" class="migrator-progress-bar-fill"><span></span></div>' +
                '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'fetch-source-cancel-button',
                title: migratorLocale.lmsg('fetchSourceButtonCancel'),
                handler: function (event, popup) {
                    cancel = true;

                    elemActionText.show();
                    elemErrorText.hide();
                    elemProgressBar.show();
                    elemCancelButton.show();
                    elemCloseButton.hide();
                    elemActionText.update(migratorLocale.lmsg('fetchSourceCancelling'));

                    new Ajax.Request(URL_CANCEL_FETCH_SOURCE + '/session/' + session);
                }
            },
            {
                id: 'fetch-source-close-button',
                title: migratorLocale.lmsg('fetchSourceButtonClose'),
                handler: function (event, popup) {
                    popup.hide();
                    if (error && onCloseWithErrors) {
                        onCloseWithErrors(error);
                    }
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();

    var elemActionText = $('fetch-source-action-text');
    var elemErrorText = $('fetch-source-error-text');
    var elemProgressBar = $('fetch-source-progress-bar');
    var elemCancelButton = $('fetch-source-cancel-button').up();
    var elemCloseButton = $('fetch-source-close-button').up();

    elemCloseButton.hide();

    function pollProgress() {
        new Ajax.Request(URL_GET_PROGRESS + '/session/' + session, {
            onSuccess: function (response) {
                var progress = response.responseText.evalJSON();

                if (
                    progress.status == overallStatus.FINISHED_OK ||
                    progress.status == overallStatus.FINISHED_WARNINGS
                ) {
                    if (cancel) {
                        cancel = false;
                        popup.hide();
                        return;
                    }
                    // Show that operation has finished and redirect to object selections screen
                    elemActionText.show();
                    elemErrorText.hide();
                    elemProgressBar.hide();
                    elemActionText.update(migratorLocale.lmsg('fetchSourceFinished'));

                    if (onFinishedSuccess) {
                        onFinishedSuccess();
                    }
                } else if (
                    progress.status == overallStatus.FINISHED_ERRORS
                ) {
                    if (cancel) {
                        cancel = false;
                        popup.hide();
                        return;
                    }

                    // Show error message
                    elemActionText.hide();
                    elemErrorText.show();
                    elemProgressBar.hide();
                    elemCancelButton.hide();
                    elemCloseButton.show();
                    elemErrorText.update(formatStr(progress.errorMessage));
                    // Set error variable so it could be passed back to display error handler
                    error = progress.errorMessage;
                } else { // Not started or in progress
                    // Update progress message if exists

                    if (!cancel) {
                        elemActionText.show();
                        elemErrorText.hide();
                        elemProgressBar.show();
                        elemCancelButton.show();
                        elemCloseButton.hide();

                        if (progress.action) {
                            elemActionText.update(formatStr(progress.action));
                        }
                    }

                    // Poll progress once more
                    setTimeout(pollProgress, FETCH_SOURCE_POLL_INTERVAL);
                }
            }
        });
    }

    pollProgress();
}