
// Show popup dialog with settings to start migration.
// Arguments: subscriptions - list of subscription names.
function showChangeIPPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_CHANGE_IP_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_CHANGE_IP_TITLE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    new Ajax.Request(URL_LIST_IP_ADDRESSES, {
        onSuccess: function (response) {
            var ipAddresses = response.responseText.evalJSON();

            function sectionTitle(title) {
                return (
                    '<div class="title">' +
                        '<div class="title-area"><h3><span>' + title + '</span></h3></div>' +
                    '</div>'
                );
            }

            function formRows(ipType) {
                 return (
                     '<div class="form-row">' +
                        '<div class="field-name">' + MESSAGE_POPUP_CHANGE_IP_MAP_TO + '</div>' +
                        '<div class="field-value">' +
                            '<div class="text-value">' +
                                '<div class="indent-box">' +
                                    '<input type="radio" name="mappingType' + ipType + '" class="radio" id="mappingAuto' + ipType + '" value="auto" checked="checked"> ' +
                                    '<label for="mappingAuto' + ipType + '">' +
                                        MESSAGE_POPUP_CHANGE_IP_MAPPING_AUTO +
                                    '</label>' +
                                '</div>' +
                                '<div class="indent-box">' +
                                    '<input type="radio" name="mappingType' + ipType + '" class="radio" id="mappingShared' + ipType + '" value="shared"> ' +
                                    '<label for="mappingShared' + ipType + '">' +
                                        MESSAGE_POPUP_CHANGE_IP_MAPPING_SHARED +
                                    '</label>' +
                                '</div>' +
                                '<div class="indent-box">' +
                                    '<input type="radio" name="mappingType' + ipType + '" class="radio" id="mappingDedicated' + ipType + '" value="dedicated"> ' +
                                    '<label for="mappingDedicated' + ipType + '">' +
                                        MESSAGE_POPUP_CHANGE_IP_MAPPING_DEDICATED +
                                    '</label>' +
                                '</div>' +
                                '<div class="indent-box">' +
                                    '<input type="radio" name="mappingType' + ipType + '" class="radio" id="mappingSelected' + ipType + '" value="selected"> ' +
                                    '<label for="mappingSelected' + ipType + '">' +
                                        MESSAGE_POPUP_CHANGE_IP_MAPPING_SELECTED +
                                    '</label>' +
                                '</div>' +
                            '</div>' +
                        '</div>' +
                    '</div>' +
                    '<div class="form-row">' +
                    '<div class="field-name">' + MESSAGE_POPUP_CHANGE_IP_MAP_TO_SELECTED + '</div>' +
                        '<div class="field-value">' +
                            '<div id="change-ip-' + ipType + '-input-container"></div>' +
                        '</div>' +
                    '</div>'
                 );
            }

            popupContent = '';
            if (ipAddresses.v6.length > 0) {
                popupContent += sectionTitle(MESSAGE_POPUP_CHANGE_IP_IPV4);
            }
            popupContent += formRows('v4');
            if (ipAddresses.v6.length > 0) {
                popupContent += sectionTitle(MESSAGE_POPUP_CHANGE_IP_IPV6);
                popupContent += formRows('v6');
            }
            popupContent = '<div class="form-box">' + popupContent + '</div>';

            var popup = new Jsw.Popup({
                title: title,
                content: popupContent,
                buttons: [
                    {
                        id: 'changeIpOkButton',
                        title: MESSAGE_POPUP_CHANGE_IP_BUTTON_OK,
                        class: 'action',
                        handler: function (event, popup) {
                            function getValue(ipType) {
                                var value = $$('input:checked[type=radio][name=mappingType' + ipType + ']').first().value;
                                if (value == 'selected') {
                                    value = $$('input[name="change-ip-' + ipType + '"]').first().value;
                                }
                                return value;
                            }

                            parameters = {
                                subscriptions: Object.toJSON(subscriptions)
                            };

                            parameters.ipv4 = getValue('v4');
                            if (ipAddresses.v6.length > 0) {
                                parameters.ipv6 = getValue('v6');
                            }

                            disableButtonInProgress($('changeIpOkButton'), 'changingButtonTitle');
                            disableButtonPlain($('changeIpCancelButton'));

                            new Ajax.Request(URL_CHANGE_IP_SUBSCRIPTIONS, {
                                parameters: parameters,
                                onSuccess: function (response) {
                                    if (onSuccess) {
                                        onSuccess();
                                    }
                                    popup.hide();
                                }
                            });
                        }
                    },
                    {
                        id: 'changeIpCancelButton',
                        title: MESSAGE_POPUP_CHANGE_IP_BUTTON_CANCEL,
                        handler: function (event, popup) {
                            popup.hide();
                        }
                    }
                ],
                popupCls: 'popup-panel popup-panel-centered migrator-popup-reassign'
            });

            popup.show();

            function addLookup(ipType, ipAddresses)
            {
                var ipLookupData = [];
                for (var i = 0; i < ipAddresses.length; i++) {
                    var ip = ipAddresses[i];
                    ipLookupData.push({id: ip, title: ip});
                }

                var lookup = new Jsw.LookUpExtended({
                    id: 'change-ip-' + ipType,
                    name: 'change-ip-' + ipType,
                    renderTo: 'change-ip-' + ipType + '-input-container',
                    data: ipLookupData,
                    value: '',
                    locale: CHANGE_IP_LOCALE
                });

                function updateLookupStatus() {
                    if ($('mappingSelected' + ipType).checked) {
                        lookup.enable();
                    } else {
                        lookup.disable();
                    }
                }

                $$('input[name="mappingType' + ipType + '"]').each(function(element) {
                    element.observe('change', updateLookupStatus)
                });

                updateLookupStatus();
            }

            addLookup('v4', ipAddresses.v4);
            if (ipAddresses.v6.length > 0) {
                addLookup('v6', ipAddresses.v6);
            }
        }
    });
}