function finishMigration(sessionId) {
    new Ajax.Request(URL_GET_SUBSCRIPTIONS_IN_QUEUE_COUNT + '/session/' + sessionId, {
        onSuccess: function (response) {
            var subscriptionsInQueue = response.responseText.evalJSON();
            var messageBoxParams = {
                'type': Jsw.messageBox.TYPE_YESNO,
                'subtype': 'delete',
                'text': MESSAGE_FINISH_MIGRATION_CONFIRMATION,
                'onYesClick': function () {
                    Jsw.redirectPost(URL_REMOVE_SESSION, {
                        session: sessionId
                    });
                },
                'buttonTitles': {
                    'yes': MESSAGE_FINISH_MIGRATION_YES,
                    'no': MESSAGE_FINISH_MIGRATION_NO
                }
            };

            if (subscriptionsInQueue > 0) {
                messageBoxParams.needAttention = true;
                messageBoxParams.needAttentionText = formatMessage(
                    MESSAGE_FINISH_MIGRATION_STOP_TASKS, subscriptionsInQueue
                );
                messageBoxParams.needAttentionBlockSubmit = true;
            }

            Jsw.messageBox.show(messageBoxParams);
        }
    });
}
