from parallels.common.utils.restore_hosting_utils import restore_hosting_settings_lock
from parallels.common.utils.windows_utils import path_join as windows_path_join
from parallels.common.utils import vdir_utils
from parallels.common.utils import plesk_utils
from parallels.common.utils.windows_utils import convert_path
from threading import Lock


class PathConverter(object):
	@staticmethod
	def convert(subscription, site, path):
		source_vhost_path = windows_path_join(
			subscription.web_source_server.vhosts_dir,
			subscription.name_idn
		)
		return convert_path(subscription, path, source_vhost_path)

def get_vdirs_list(global_context, subscription, site):
	"""Get list of virtual directories of a site

	Returns: list of strings - virtual directory paths

	Note that function relies on transfer virtual directories action, which should write
	converted virtual directory XML to a file in session directory
	"""
	vdir_info_source = _load_vdirs_xml(global_context, site).decode('utf-8')
	vdirs_list_source = vdir_utils.get_vdirs_list(vdir_info_source)
	with restore_hosting_settings_lock:
		vdir_info_target = plesk_utils.get_vdir_info(subscription.web_target_server, site.name)
	vdirs_list_target = vdir_utils.get_vdirs_list(vdir_info_target)

	return vdirs_list_source & vdirs_list_target


def _load_vdirs_xml(global_context, site):
	filename = global_context.session_files.get_converted_vdir_xml(
		site.name
	)
	with open(filename, 'rb') as f:
		return f.read()


source_websrvmng_lock = Lock()