from parallels.plesks_migrator.actions.fetch.fetch_backup import FetchBackupActionBase


class FetchCentralizedMailBackupAction(FetchBackupActionBase):
	def get_description(self):
		return "Fetch configuration data from centralized mail servers"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed fetch configuration data from centralized mail servers"

	@staticmethod
	def _get_source_servers(global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return global_context.conn.get_centralized_mail_servers()