from parallels.common import messages
import logging
import os

from parallels.common import MigrationNoContextError
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.migration_list.utils import get_migration_list_file_location
from parallels.utils import get_executable_file_name, strip_multiline_spaces

logger = logging.getLogger(__name__)


class CheckMigrationListExistsForMigration(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_MIGRATION_LIST_FILE_EXISTS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_MIGRATION_LIST_FILE_1

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		migration_list_file = get_migration_list_file_location(global_context)

		if not os.path.exists(migration_list_file):
			raise MigrationNoContextError(strip_multiline_spaces(messages.MIGRATION_LIST_IS_NOT_DEFINED_PLEASE) % (
				migration_list_file,
				get_executable_file_name(),
				)
			)
