from parallels.common import messages
from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties
from parallels.common.target_panels import TargetPanels

class RemoveDomainKeys(SubscriptionBackupAction):
	"""Domain keys are not implemented on PPA side, remove them from backup""" 

	def get_description(self):
		return messages.REMOVE_DOMAINS_KEYS_FROM_BACKUP

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_DOMAIN_KEYS_FOR_SUBSCRIPTION % (subscription.name)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		if global_context.target_panel != TargetPanels.PPA:
			# applicable to PPA only, for Plesk we can restore domain keys
			# without any issues
			return

		if subscription_backup.mailsystem is not None:
			subscription_backup.mailsystem.remove_domainkeys()
