from collections import namedtuple

from parallels.utils.xml import elem, text_elem

from .. import core

MailUserInfo = namedtuple('MailUserInfo', ('name'))


class MailOperator(object):
	class Dataset(object):
		GEN_INFO = 'gen_info'
		values = [GEN_INFO]

	FilterBySiteId = core.declare_filter('FilterBySiteId', 'site-id')

	class SetPrefs(core.operation_with_filter('Get', ('nonexistent_user',))):
		operator_name = 'mail'
		operation_name = 'set_prefs'
		min_api_version = '1.6.3.0'
		max_api_version = None

		class NonexistentUserForward(namedtuple('NonexistentUserForward', ('forward'))):
			def inner_xml(self):
				return text_elem('forward', self.forward)

		class NonexistentUserReject(object):
			def inner_xml(self):
				return elem('reject')

		def data_xml(self):
			xml = []
			if self.nonexistent_user is not None:
				xml.append(
					elem('prefs', [
						elem('nonexistent-user', 
							[self.nonexistent_user.inner_xml()]
						)]
					)
				)
			return xml
					
		@classmethod
		def parse(cls, elem):
			return [core.Result.parse(r) for r in elem.findall('result')]

	class Get(core.operation_with_filter('Get', ('mailbox',))):
		operator_name = 'mail'
		operation_name = 'get_info'
		min_api_version = '1.6.3.0'
		max_api_version = None

		def data_xml(self):
			return [
				elem('mailbox', [])
			]

		@classmethod
		def parse(cls, elem):
			return core.parse_result_set(elem,  cls._parse_data, 'mailname')

		@classmethod
		def _parse_data(cls, elem):
			return MailUserInfo (
				name=elem.findtext('mailname/name')
			)