import parallels

from parallels.utils import cached
from parallels.common.connections.source_server import SourceServer
from parallels.common.utils.migrator_utils import get_package_extras_file_path


class Helm3SourceServer(SourceServer):
	@cached
	def get_path_to_mysqldump(self):
		mysqldump_path = self.get_session_file_path('mysqldump.exe')
		extras_mysqldump_path = get_package_extras_file_path(
			parallels.helm3_migrator, "mysqldump.exe"
		)
		with self.runner() as runner:
			runner.upload_file(extras_mysqldump_path, mysqldump_path)

		return mysqldump_path

	@cached
	def get_path_to_mysql(self):
		mysql_path = self.get_session_file_path('mysql.exe')
		extras_mysql_path = get_package_extras_file_path(
			parallels.helm3_migrator, "mysql.exe"
		)
		with self.runner() as runner:
			runner.upload_file(extras_mysql_path, mysql_path)

		return mysql_path

	def __repr__(self):
		return 'Helm3SourceServer(%r)' % (self.node_id,)