from textwrap import dedent

from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class CheckTargetPanelSupportsForwarding(CommonAction):
	def get_description(self):
		return "Check if target panel supports DNS forwarding"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check if target panel supports DNS forwarding"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		if not global_context.target_panel_obj.has_dns_forwarding():
			raise MigrationError(dedent(u"""\
				DNS forwarding is not supported when migrating to Parallels
				Plesk Panel. Switch IP addresses of DNS servers manually at
				registar."""))
