from parallels.common.target_panels import TargetPanels
from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.actions.hosting_settings.convert.plesk.dns \
	import DNS as ActionConvertDNSPlesk
from parallels.helm3_migrator.actions.hosting_settings.convert.ppa.dns \
	import DNS as ActionConvertDNSPPA

class DNS(SubscriptionAction):
	def get_description(self):
		return "Convert DNS records"

	def get_failure_message(self, global_context, subscription):
		return "Failed to convert DNS records for subscription '%s'" % (subscription.name)

	def filter_subscription(self, global_context, subscription):
		return True

	def run(self, global_context, subscription):
		if global_context.target_panel == TargetPanels.PLESK:
			ActionConvertDNSPlesk().run(global_context, subscription)
		elif global_context.target_panel == TargetPanels.PPA:
			ActionConvertDNSPPA().run(global_context, subscription)
		else:
			raise NotImplementedError(
				"DNS conversion is implemented only for Plesk and PPA"
			)
