package EnsimGuidGenerator;

use strict;

use UUID::Tiny ':std';

use constant PPCPL_ADMIN_NAMESPACE_GUID    => string_to_uuid('5a43be7a-00df-11e3-a4c8-003048db220a');
use constant PPCPL_RESELLER_NAMESPACE_GUID => string_to_uuid('5a7251e0-00df-11e3-949e-003048db220a');
use constant PPCPL_CLIENT_NAMESPACE_GUID   => string_to_uuid('5a9bc106-00df-11e3-b7e6-003048db220a');
use constant PPCPL_DOMAIN_NAMESPACE_GUID   => string_to_uuid('5ac0b308-00df-11e3-a069-003048db220a');

my $uuidType = UUID_SHA1_AVAIL() ? UUID_V5 : UUID_V3;

sub getAdminGuid() {
  # it's ok to loosely forge admin guid (PMM TL)
  return getUuidV35(PPCPL_ADMIN_NAMESPACE_GUID, 'admin');
}

sub getResellerGuid($) {
  my ($resellerName) = @_;
  return getUuidV35(PPCPL_RESELLER_NAMESPACE_GUID, $resellerName);
}

sub getClientGuid($) {
  my ($clientName) = @_;
  return getUuidV35(PPCPL_CLIENT_NAMESPACE_GUID, $clientName);
}

sub getDomainGuid($) {
  my ($domainName) = @_;
  return getUuidV35(PPCPL_DOMAIN_NAMESPACE_GUID, $domainName);
}

sub getUuidV35($$) {
  my ($namespace, $name) = @_;
  return uuid_to_string(create_uuid($uuidType, $namespace, $name));
}

1;
