import logging

from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties

logger = logging.getLogger(__name__)

class ChangeWebmailToHorde(SubscriptionBackupAction):
	"""Plesk/PPA 11.5 does not support atmail as webmail, so we change it in
	backup to prevent warning on hosting restore step also we change any not
	supported webmail to horde in order to prevent warnings on restore"""

	def get_description(self):
		return "Change webmail from old webmails to Horde"

	def get_failure_message(self, global_context, subscription):
		return "Failed to change webmail for subscription '%s'" % (subscription.name)

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		s_mailsystem = subscription_backup.mailsystem

		if s_mailsystem is not None:
			if s_mailsystem.get_webmail() not in ['horde', 'roundcube']:
				s_mailsystem.set_webmail('horde')
				logger.debug(u"Subscription '%s' has webmail that does not support in PPA, so it's changed to horde." % subscription.name)
