from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.actions.utils.multithreading_properties import MultithreadingProperties


class CopyDatabaseContent(SubscriptionAction):
	def get_description(self):
		return "Copy databases"

	def get_failure_message(self, global_context, subscription):
		return (
			u"Failed to copy database content of subscription. "
			u"Most probably that happens because of a network-related issue. Please check "
			u"network connections between source and target servers, then re-copy"
			u"database content with the help of 'copy-db-content' command"
		)

	def filter_subscription(self, global_context, subscription):
		return True

	def get_multithreading_properties(self):
		return MultithreadingProperties(can_use_threads=True)

	def run(self, global_context, subscription):
		global_context.migrator._copy_single_subscription_db_content(
			subscription
		)
