from parallels.pmm_unix_migrator.pmm_agent import PmmMigrationAgentBase

class PPCPLPmmMigrationAgent(PmmMigrationAgentBase):
	def __init__(self, migrator_pmm_dir, server, settings):
		cli_options = '--dump-all --configuration-only --server -v 5'
		super(PPCPLPmmMigrationAgent, self).__init__(
			migrator_pmm_dir, server, settings, cli_options
		)

	def get_domain_subdomain_dirs(self, domain_name):
		"""Run script that gets full paths to subdomain directories.

		Returns dictionary: {subdomain_short_name: (www_root, cgi_root)}
		"""
		with self.server.runner() as runner:
			output = runner.sh(
				ur'cd {path}; perl ListSubdomainDirectories.pl {domain_name}',
				{
					'path':	self.settings.agent_home,
					'domain_name': domain_name
				}
			).strip()

		result = {}

		lines = output.split("\n")
		for line in lines:
			line = line.strip()
			if line != '':
				subdomain, www_root, cgi_root = line.split("\t")
				result[subdomain] = (www_root, cgi_root)

		return result

	def get_mysql_admin_password(self):
		"""Run script that gets MySQL admin password to copy database content
		
		Return string - the password"""

		with self.server.runner() as runner:
			return runner.sh(
				ur'cd {path}; perl MySQLAdminPassword.pl',
				{
					'path':	self.settings.agent_home,
				}
			)
