from parallels.core.converter.business_objects.clients import ClientsConverter
from parallels.core.utils.common import join_nonempty_strs


class POAClientsConverter(ClientsConverter):
	"""Generate list of customers ready to import to target panel, specific to POA"""

	def convert_clients(self, *args, **kwargs):
		converted_clients = super(POAClientsConverter, self).convert_clients(*args, **kwargs)
		for client in converted_clients:
			self.fix_poa_company_name(client)
		return converted_clients

	@staticmethod
	def fix_poa_company_name(client):
		"""Fix company name for client to workaround issue with empty name in POA UI

		In PPA POA UI on many pages customer is identified by company name,
		and you don't see its first and last names. As company is often empty
		on source panels, a workaround is applied: we put client's contact as
		a company name. Otherwise you see a lot of rows it tables that differ
		only by id. This workaround should be removed as soon as bug #120645
		is fixed on PPA side

		:type client: parallels.core.target_data_model.Client
		"""
		if client.company is None or client.company == '':
			client.company = join_nonempty_strs([
				client.personal_info.first_name,
				client.personal_info.last_name
			])