import posixpath


class HostingServer(object):
	"""Common features of Plesk hosting server, panel independent."""

	def __init__(self, server):
		"""Initialize with an object of type 'TargetServer'."""
		self.server = server

	def get_unix_vhost_dirs(self, runner, domain_name):
		"""
		Return a list of domain hosting content directories.

		Arguments:
			runner: XXX Remove unused parameter
			domain_name: Plesk domain name
		Returns:
			A list of directories.
		"""
		return [posixpath.join(
			self.server.vhosts_dir, domain_name.encode('idna')
		)]

	def get_unix_vhost_error_log_files(self, domain_name):
		"""Return a list of domain error log files."""
		return [
			'{vhost_root}/system/{domain}/logs/error_log'.format(
				domain=domain_name.encode('idna'),
				vhost_root=self.server.vhosts_dir
			),
		]

	def get_unix_domain_mail_dirs(self, runner, domain_name):
		"""
		Return a list of domain mail content directories.

		Arguments:
			runner: XXX Remove unused parameter
			domain_name: Plesk domain name
		Returns:
			A list of directories.
		"""
		return [posixpath.join(
			self.server.mail_dir, domain_name.encode('idna')
		)]
