from parallels.core.actions.base.entry_point_action import EntryPointAction
from parallels.core.utils.backup_adapter import SubscriptionBackupRaw, SubscriptionBackup
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.actions.hosting_settings.restore_catch_all_smartermail_assimilate import \
	RestoreCatchAllSmartermailAssimilate
from parallels.plesk.actions.hosting_settings.reset_hosting_for_nohosting_subscription import \
	ResetHostingForSubscriptionWithoutHosting
from parallels.plesk.actions.hosting_settings.verify import VerifyHostingSettings
from parallels.plesk.actions.apache_restart_interval.set import SetApacheRestartInterval
from parallels.ppa.actions.apache_restart_interval.restore import RestoreApacheRestartIntervalPPA
from parallels.ppa.actions.check_main_node_license import CheckMainNodeLicense
from parallels.ppa.actions.check_service_node_licenses import CheckServiceNodeLicenses
from parallels.ppa.actions.hosting_settings.check.catch_all_redirect import CatchAllRedirect
from parallels.ppa.actions.hosting_settings.check.maillists import Maillists
from parallels.ppa.actions.hosting_settings.convert.change_catch_all_redirect import ChangeCatchAllRedirect
from parallels.ppa.actions.hosting_settings.convert.change_no_hosting_subscription_web_ips import \
	ChangeNoHostingSubscriptionWebIPsPPA
from parallels.ppa.actions.hosting_settings.convert.cleanup_xml_for_ppa import CleanupBackupXMLForPPA
from parallels.ppa.actions.hosting_settings.convert.remove_disabled_mailsystem_without_resource import \
	RemoveDisabledMailsystemWithoutResource
from parallels.ppa.actions.hosting_settings.convert.remove_domain_keys import RemoveDomainKeys
from parallels.ppa.actions.hosting_settings.convert.remove_maillists import RemoveMaillists
from parallels.ppa.actions.hosting_settings.convert.remove_smartermail_unsupported_features import \
	RemoveSmartermailUnsupportedFeatures
from parallels.ppa.actions.import_clients_and_subscriptions import ImportClientsAndSubscriptions
from parallels.ppa.actions.remove_webspace import RemoveWebspace


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with ppa-specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		:rtype None
		"""
		workflow.get_path('transfer-accounts').insert_action(
			'restore-apache-restart-interval', RestoreApacheRestartIntervalPPA(), after='remove-imported-backups'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'set-apache-restart-interval', SetApacheRestartInterval(), after='check-main-node-disk-space-requirements'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'check-plesk-infrastructure',
			workflow.get_shared_action_pointer('check-infrastructure'),
			after='set-windows-security-policy'
		)
		workflow.get_path('transfer-accounts/restore').insert_action(
			'import-clients-and-subscriptions', ImportClientsAndSubscriptions()
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-catch-all-smartermail-assimilate', RestoreCatchAllSmartermailAssimilate(),
			after='restore-hosting-settings'
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'reset-hosting-for-subscription-without-hosting',
			ResetHostingForSubscriptionWithoutHosting(), after='import-backups'
		)
		workflow.get_path('transfer-accounts').register_shutdown(
			'set-apache-restart-interval',
			'restore-apache-restart-interval'
		)

		workflow.get_shared_action('verify-hosting').insert_action(
			'verify-hosting-settings', VerifyHostingSettings()
		)

		workflow.get_shared_action('convert-hosting').insert_action(
			'cleanup-backup-xml-for-ppa', CleanupBackupXMLForPPA(),
			before='save-backup'
		)

		workflow.get_path('check/check-data').insert_action(
			'check-catch-all-redirect',
			CatchAllRedirect(SubscriptionBackupRaw())
		)
		workflow.get_path('check/check-data').insert_action(
			'check-maillists',
			Maillists(SubscriptionBackupRaw())
		)

		workflow.get_shared_action('convert-hosting').insert_action(
			'check-catch-all-redirect',
			CatchAllRedirect(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'check-maillists',
			Maillists(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'change-catch-all-redirect',
			ChangeCatchAllRedirect(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'remove-maillists',
			RemoveMaillists(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'remove-domain-keys',
			RemoveDomainKeys(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'remove-smartermail-upsupported-features',
			RemoveSmartermailUnsupportedFeatures(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'remove-disabled-mailsystem-without-resource',
			RemoveDisabledMailsystemWithoutResource(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'change-no-hosting-subscription-web-ips',
			ChangeNoHostingSubscriptionWebIPsPPA(SubscriptionBackup()),
			after='change-hosting-subscription-web-ips'
		)
		workflow.get_shared_action('check-target-licenses').insert_action(
			'check-main-node-license',
			CheckMainNodeLicense()
		)
		workflow.get_shared_action('check-target-licenses').insert_action(
			'check-service-nodes-licenses',
			CheckServiceNodeLicenses()
		)

		workflow.add_entry_point('remove-webspace', EntryPointAction())
		workflow.get_path('remove-webspace').insert_action(
			'check-connections',
			workflow.get_shared_action_pointer('check-connections')
		)
		workflow.get_path('remove-webspace').insert_action(
			'remove-webspace',
			RemoveWebspace()
		)

