from parallels.core import checking
from parallels.core.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.ppa.converter.converter import PPAConverter


class TargetPPAClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
	def convert(self, global_context, converted_resellers, report):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		converter = PPAConverter(
			global_context.conn.target.panel_admin_password, global_context.target_existing_objects,
			global_context.options, global_context.migrator.multiple_webspaces
		)
		converter.set_ip_mapping(global_context.ip_mapping)
		plain_report = checking.PlainReport(report, *global_context.migrator._extract_source_objects_info())
		converter.convert_dumps(
			global_context.get_source_servers_info(), plain_report,
			global_context.migration_list_data.subscriptions_mapping,
			global_context.migration_list_data.customers_mapping,
			converted_resellers,
			global_context.password_holder,
			custom_subscriptions_allowed=global_context.target_panel_obj.has_custom_subscriptions_feature()
		)
		converter.fix_emails_of_aux_users()
		return converter.get_target_model()
