"""Model with high-level objects that represents our expectations after migration, specific to target Plesk

It includes objects already existing on target panel, and objects that should
be created on target panel.
"""
from collections import namedtuple

AdminResellerPlan = namedtuple(
	'AdminResellerPlan', (
		'source',
		'name',
		'overuse',
		'oversell',
		# dictionary {limit name: limit value}
		'limits',
		# dictionary {permission name: permission value}
		'permissions',
		# AdminResellerPlanApsBundleFilter
		'aps_bundle_filter'
	)
)
AdminResellerPlanApsBundleFilter = namedtuple('AdminResellerPlanApsBundleFilter', ('type', 'items'))
AdminResellerPlanApsBundleFilterItem = namedtuple('AdminResellerPlanApsBundleFilterItem', ('name', 'value'))

HostingPlanSettings = namedtuple('PleskPlanSettings', (
	'overuse', 'limits', 'permissions', 'php_settings_node', 'log_rotation',
	'mail', 'preferences', 'virtual_hosting_enabled',
	'hosting', 'performance', 'web_server_settings',
	'aps_bundle_filter', 'custom_plan_items', 'default_db_servers'
))
HostingPlanHostingSetting = namedtuple('PleskPlanHostingSetting', ('name', 'value',))
HostingPlanLogRotation = namedtuple('HostingPlanLogRotation', ('status', 'settings'))
HostingPlanLogRotationSettings = namedtuple('HostingPlanLogRotationSettings', (
	'log_condition',  # HostingPlanLogRotationConditionBySize | HostingPlanLogRotationConditionByTime
	'log_max_num_files', 'log_compress', 'log_email'
))
HostingPlanLogRotationConditionBySize = namedtuple('HostingPlanLogRotationConditionBySize', (
	'size',  # size in Kb
))
HostingPlanLogRotationConditionByTime = namedtuple('HostingPlanLogRotationConditionByTime', (
	'time',  # Daily | Weekly | Monthly
))
HostingPlanMail = namedtuple('HostingPlanMail', (
	# HostingPlanMailNonexistentUserBounce | HostingPlanMailNonexistentUserForward |
	# PleskPlanMailNonexistentUserReject
	'nonexistent_user',
	# bool
	'webmail',
))
HostingPlanMailNonexistentUserBounce = namedtuple('HostingPlanMailNonexistentUserBounce', (
	'message'
))
HostingPlanMailNonexistentUserForward = namedtuple('HostingPlanMailNonexistentUserForward', (
	'address'
))
HostingPlanApsBundleFilter = namedtuple('HostingPlanApsBundleFilter', ('type', 'items'))
HostingPlanApsBundleFilterItem = namedtuple('HostingPlanApsBundleFilterItem', ('name', 'value'))


class HostingPlanMailNonexistentUserReject(object):
	pass

HostingPlanPreferences = namedtuple('HostingPlanPreferences', (
	# int
	'stat',
	# boolean
	'maillists',
	# boolean
	'mailservice',
	# basestring, 'master' | 'slave'
	'dns_zone_type',
))
HostingPlanPerformance = namedtuple('HostingPlanPerformance', ('bandwidth', 'max_connections',))
HostingPlanWebServerSettings = namedtuple('HostingPlanWebServerSettings', (
	'additional', 'additional_ssl', 'additional_nginx'
))
HostingPlanCustomItem = namedtuple('HostingPlanCustomItem', (
	'name', 'guid', 'visible', 'hint', 'description',
	'url', 'options',
))
HostingPlanDefaultDatabaseServer = namedtuple('HostingPlanDefaultDatabaseServer', (
	'type', 'host', 'port'
))

ResellerSettings = namedtuple('ResellerSettings', ('limits', 'permissions', 'overuse', 'oversell',))