from contextlib import contextmanager


class TargetServer(object):
	"""Base interface to interact with target server and get various common information about it.
	"""

	@contextmanager
	def runner(self):
		raise NotImplementedError()

	def is_windows(self):
		raise NotImplementedError()

	def description(self):
		raise NotImplementedError()

	def ip(self):
		raise NotImplementedError()

	def get_session_file_path(self, filename):
		raise NotImplementedError()

	def session_dir(self):
		raise NotImplementedError()

	@property
	def python_bin(self):
		if self.is_windows():
			# Not implemented for target server, consider it has no Python. Implement in child classes
			# if you need to use Python there.
			return None
		else:
			# use default OS Python
			return 'python'

	def __hash__(self):
		"""Implement for using nodes as dictionary keys, for the purpose of grouping"""
		raise NotImplementedError()

	def __eq__(self, another):
		"""Implement for using nodes as dictionary keys, for the purpose of grouping"""
		raise NotImplementedError()