# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package Storage::ContentNameCreator;

use strict;

use Storage::FileNameCreator;
use BranchTracker;
use File::Spec;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init{
  my( $self ) = @_;
  $self->{fnamecreator} = Storage::FileNameCreator->new();
  $self->{branchtracker} = BranchTracker->instance();
}

sub getDirectory {
  my ($self, @pathComponents) = @_;
  my $dir = File::Spec->catdir( 
    $self->{branchtracker}->getPathAsArray(),
	@pathComponents,
  );
  return $dir;
}

sub getPhostingDstFile {
  my ($self, $type, $domainName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId), 'phosting');
  return  $self->{fnamecreator}->getFileName($dir, '', '', $type);
}

sub getSubdomainDstFile {
  my ($self, $type, $domainName, $subdomainName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId), 'phosting', 'subdomain');
  return $self->{fnamecreator}->getFileName($dir, '', '', $subdomainName."_".$type);
}

sub getDbDstFile {
  my ($self, $type, $domainName, $dbName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId), 'databases', $dbName);
  return $self->{fnamecreator}->getFileName($dir, '', '', $type);
}

sub getWebUserDstFile {
  my ($self, $domainName, $wuName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId), 'phosting');
  return $self->{fnamecreator}->getFileName($dir, '', '', $wuName);
}

sub getMailnameDstFile {
  my ($self, $mailname, $domainName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId), 'mailnames');
  return $self->{fnamecreator}->getFileName($dir, '', '', "mailname_" . $mailname);
}

sub getMaillistDstFile {
  my ($self, $listname, $domainName, $domainId) = @_;
  my $dir = $self->getDirectory('domains', $self->{fnamecreator}->normalize_long_string($domainName, $domainId));
  return $self->{fnamecreator}->getFileName($dir, '', '', "maillist_". $listname);
}


1;
