# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package DatabaseContentDumper;

use strict;
use warnings;

use Logging;
use XmlNode;
use Dumper;

# TODO copied as-is from PPCPL migration agent
sub getDatabaseContent {
  my ($base, $dbAdminLogin, $dbAdminPassword, $dbName, $dbType, $domainName) = @_;
  my $domainId = Dumper::getSiteIdByDomain($domainName);

  my $contentFileName = $base->{namecreator}->getDbDstFile('sqldump', $domainName, $dbName, $domainId);
  my $sqldumpNode = $base->{archive_transport}->addDbContent($contentFileName, (
    'type' => $dbType,
    'name' => $dbName,
    'user' => $dbAdminLogin,
    'password' => $dbAdminPassword));
  if (ref($sqldumpNode) eq 'XmlNode') {
    return XmlNode->new('content', 'children' => [$sqldumpNode]);
  }

  Logging::debug("No database content found for '$dbName'.");
  return;
}

1;
