# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package ContentDumperBase;

use strict;
use warnings;

use ContentTransport::Archive;
use ContentTransport::Rsync;
use Storage::ContentNameCreator;

use vars qw|@ISA|;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init {
  my ($self, $storagepolicy) = @_;

  $self->{storage} = $storagepolicy;
  $self->{namecreator} = Storage::ContentNameCreator->new();
  
  $self->{content_transport_type} = 'archive';
  $self->{archive_transport} = ContentTransport::Archive->new( $self, $self->{storage} );
  # always use archive content transport for some cids (sql_dump, error_docs)
  $self->{content_transport} = $self->{archive_transport};
}

sub addRsyncTransport {
  my ($self, $parametersRef) = @_;
  $self->{'rsync_transport'} = ContentTransport::Rsync->new($parametersRef, $self->{storage});
  $self->{'rsync_allowed_for_content'} = {};
  return 0;
}

sub setAllowedContentForRsync {
  my $self = shift;
  $self->{'rsync_allowed_for_content'} = { map { $_ => 1 } @_ };
  return 0;
}

sub addContent {
  my ($self, $contentType, $contentFileName, %options) = @_;

  my $transport = $self->{content_transport};
  my $rsyncAllowed = $self->{'rsync_allowed_for_content'};
  if (ref $rsyncAllowed eq 'HASH' and exists($rsyncAllowed->{$contentType})) {
    $transport = $self->{'rsync_transport'} if exists $self->{'rsync_transport'};
  }

  return $transport->addContent($contentType, $contentFileName, %options);
}

sub getContentTransportDescription {
  my ($self) = @_;

  my $transport = $self->{'content_transport'};

  # we magically know that only rsync will produce a node
  if (exists($self->{'rsync_transport'})) {
    $transport = $self->{'rsync_transport'};
  }

  return $transport->getContentTransportDescription();
}

1;
