package EnsimDomain;

use strict;
use warnings;

use LegacyPanel::Entity::Domain;
our @ISA = qw/ LegacyPanel::Entity::Domain /;

use Dumper;

# instance 

sub _initLoad($) {
}

sub getCronJobs($) {
  my ($self) = @_;
  return Dumper::getClientCronJobs($self->getId());
}

sub getMaillists($) {
  my ($self) = @_;
  return Dumper::getMaillists($self->getId());
}

sub getClientIPPool($) {
  my ($self) = @_;
  return Dumper::getClientIPPool($self->getId());
}

sub getDatabaseUsers($) {
  my ($self) = @_;
  my $databaseUsers = 'databaseUsers';

  unless (exists($self->{$databaseUsers})) {
    my @databases = $self->getDatabaseNames();
    my @users = ();
    if (scalar(@databases)) {
      @users = Dumper::getDatabaseUsers($databases[0], ['root']);
    }
    $self->{$databaseUsers} = \@users;
  }

  return @{$self->{$databaseUsers}};
}

sub getDatabaseNames($) {
  my ($self) = @_;
  my $databases = 'databases';
  
  unless (exists($self->{$databases})) {
    $self->{$databases} = [ Dumper::getDatabaseNames($self->getId()) ];
  }

  return @{$self->{$databases}};
} 

sub getConsumedDiskSpace($) {
  my ($self) = @_;

  return Dumper::getDomainDiskQuotaUsed($self->getId());
}

# informational

sub isEnabled($) {
  my ($self) = @_;
  return not Dumper::isDisabledSite($self->_getSiteId());
}

sub isPowerToolsAvailable($) {
  my ($self) = @_;
  return Dumper::getPowerToolsAvailability($self->getId());
}

# internal

sub _getSiteId($) {
  my ($self) = @_;

  unless (exists($self->{'siteId'})) {
    $self->{'siteId'} = Dumper::getSiteIdByDomain($self->getId());
  }

  return $self->{'siteId'};
}

1;
