# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package PreMigrationMessages;

use strict;
use warnings;

use PreMigration;

# Context variables common to all messages
our %COMMON_CONTEXT = (
    'panelName' => 'PPCPL',
  );

our %MESSAGES = (
  'ENABLED_SITE_HAS_NO_IPINFO' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => 'An inconsistency was found: the site {domain} is enabled, but information about its IP address is missing.',
    'detailedMessage' => '{panelName} internal error occurred.'
  },
  'DUPLICATED_SITE_LOGIN_NAMES' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => "Duplicate site administrator usernames were found on the {panelName} installation.",
    'detailedMessage' => "Parallels Plesk Panel does not allow duplicate usernames. Duplicates will be automatically renamed during migration. The affected usernames are {duplicateList}."
  },
  'POWER_TOOLS_AVAILABLE' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    # TODO it may also be useful to find actual usage of power tools 
    # (complicated because there is a separate database table per application, i.e a table named 'xoops-2.0.16-1.0')
    'briefMessage' => "There are power tools available to the administrator of the site {domain}. The control panel settings of installed power tools will not be migrated.",
    'detailedMessage' => "The installed power tools can only be migrated as files. Application files and databases will be migrated, but the settings in control panel will not. The application settings and functionality should be verified after migration."
  },
  'MAILING_LISTS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "There are mailing lists used by the administrator of the site {domain}. Message archives will not be migrated.",
    'detailedMessage' => "Only administrator's e-mail, password, and subscribers' e-mail addresses are migrated."
  },
  'CRON_JOBS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "Site '{domain}' has crontab entries. Cron jobs cannot be migrated.",
    'detailedMessage' => 'Migration of crontab entries is not supported by the current version of migration agent. You should move all crontab entries to Parallels Plesk Panel server manually.'
  },
  'MAILQUOTA_IS_APPROXIMATED' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::MAIL,
    'briefMessage' => "Site users' mail quota will be set to the value of total disk quota",
    'detailedMessage' => "In Parallels Plesk Panel, mail quota is a separate setting. When migrating site users, PPCPL user's total disk quota will be used as approximation for mail quota."
  },
  'NAMED_NOT_RUNNING' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::DNS,
    'briefMessage' => "DNS zones migration is not possible: 'named' service is stopped",
    'detailedMessage' => "Migration of DNS zones is not possible while 'named' service is stopped. Please start the service if DNS zones migration is desired."
  },
  'DB_USER_ADMIN' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::DB,
    'briefMessage' => "DB user 'admin' in site '{domain}' will be renamed upon migration.",
    'detailedMessage' => "DB user name 'admin' is prohibited in Plesk. You may rename it manually or it will be renamed automatically during migration.",
  },

);
