package ContentDumper;

use strict;

use Logging;
use Dumper;
use XmlNode;

sub getPHostingContent {
  return undef;
}

sub _DirIsEmpty
{
    my ($path) = @_;
    opendir DIR, $path;
    while(my $entry = readdir DIR) {
        next if($entry =~ /^\.\.?$/);
        closedir DIR;
        return 0;
    }
    closedir DIR;
    return 1;
}


sub getSubdomainPHostingContent {
  my ($base, $domainName, $pHostingNode, $subdomainName, $wwwdir, $cgidir) = @_;

  Logging::trace("Getting SubdomainPhosting content for domain '$domainName' with subdomain '$subdomainName' ... ");

  if (defined($cgidir) && $cgidir !~ m/^\s*$/)
  {
     unless (_DirIsEmpty(Dumper::getFilesystemByDomainName($domainName) . "$cgidir")) {
        $pHostingNode->setAttribute('cgi_bin_mode', "www-root");     # this is realy require for Plesk, for access to "cgi-bin"
                                                                     # directories for ftpusers/owners of subdomains.
                                                                     # And yes, it's UGLY hack for this place, but it simplest way.
    }
  }
  return undef;
}


sub getAnonFtpContent {
  my ($base, $domainName) = @_;
  my $domainDir = Dumper::getFilesystemByDomainName($domainName);

  unless (_DirIsEmpty("${domainDir}/var/ftp/pub") && _DirIsEmpty("${domainDir}/var/ftp/uploads")) {
    my $contentNode = XmlNode->new('content');
    return $contentNode;
  } else {
    Logging::info("No anonymous FTP content found for domain '$domainName'.");
    return undef;
  }
}

sub getWebUserSiteContent {
  my ($base, $domainName, $webUserName) = @_;

  unless(_DirIsEmpty(Dumper::getFilesystemByDomainName($domainName) . "/home/$webUserName/public_html")) {
    return XmlNode->new('content');
  }

  Logging::info("No site content found for web user $webUserName at domain $domainName");
}

sub getMailBoxContent {
  return undef;
}

1;
