/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.xmind.core.ITopic;
import org.xmind.gef.Request;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.AbstractEditPolicy;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.DependencyEditDialog;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class DependencySelectablePolicy
extends AbstractEditPolicy {
    private static final DependencySelectablePolicy instance = new DependencySelectablePolicy();

    public boolean understands(String requestType) {
        return "open".equals(requestType) || super.understands(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("open".equals(type)) {
            this.handleOpen(request);
        }
    }

    private void handleOpen(Request request) {
        IPart target = request.getPrimaryTarget();
        Object model = target.getModel();
        if (model instanceof Dependency) {
            Dependency dependency = (Dependency)model;
            DependencyEditDialog dialog = new DependencyEditDialog(request.getTargetViewer().getControl().getShell(), dependency.getSuccessor(), dependency);
            int ret = dialog.open();
            if (ret == 0) {
                ITopic newTask = dialog.getTask();
                String newType = dialog.getType();
                TaskInfoUtils.changeDependency((Dependency)dependency, (ITopic)newTask, (String)newType, (ICommandStack)request.getTargetCommandStack());
            } else if (ret == 1025) {
                TaskInfoUtils.removeDependency((Dependency)dependency, (ICommandStack)request.getTargetCommandStack());
            }
        }
    }

    public static DependencySelectablePolicy getInstance() {
        return instance;
    }
}

