/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.ITopic;
import org.xmind.ui.gantt2.viewer.IFoldingStatusChangeListener;

public class Configurations {
    private Map<ITopic, Boolean> foldingStatus = new HashMap<ITopic, Boolean>();
    private List<IFoldingStatusChangeListener> foldingStatusChangeListeners = new ArrayList<IFoldingStatusChangeListener>(2);

    public boolean isFolded(ITopic task) {
        Boolean s = this.foldingStatus.get(task);
        return s != null && s != false;
    }

    public void toggleFolded(ITopic task) {
        this.setFolded(task, !this.isFolded(task));
    }

    public void setFolded(ITopic task, boolean folded) {
        boolean oldFolded = this.isFolded(task);
        this.foldingStatus.put(task, folded);
        if (oldFolded != folded) {
            this.fireFoldingStatusChanged(task, folded);
        }
    }

    protected void fireFoldingStatusChanged(ITopic task, boolean folded) {
        Object[] objectArray = this.foldingStatusChangeListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IFoldingStatusChangeListener)listener).foldingStatusChanged(task, folded);
            ++n2;
        }
    }

    public void addFoldingStatusChangeListener(IFoldingStatusChangeListener listener) {
        this.foldingStatusChangeListeners.add(listener);
    }

    public void removeFoldingStatusChangeListener(IFoldingStatusChangeListener listener) {
        this.foldingStatusChangeListeners.remove(listener);
    }
}

