/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ModelPartHandler {
    @Execute
    public void run(EPartService partService, @Named(value="org.xmind.ui.commandParameter.modelPart.partId") String partId, @Optional @Named(value="org.xmind.ui.commandParameter.modelPart.pageId") String pageId, @Optional @Named(value="org.xmind.ui.commandParameter.modelPart.partStackId") String partStackId, MApplication appli, EModelService modelService) {
        if (partId == null) {
            return;
        }
        MPartDescriptor partDescriptor = null;
        for (MPartDescriptor mp : appli.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            partDescriptor = mp;
            break;
        }
        if (partDescriptor == null) {
            return;
        }
        List partStacks = modelService.findElements((MUIElement)appli, partStackId, MPartStack.class, null);
        boolean partStackExisted = !partStacks.isEmpty();
        MPartStack partStack = partStackExisted ? (MPartStack)partStacks.get(0) : this.createPartStack(modelService, partStackId);
        MPart p = partService.findPart(partId);
        if (p == null) {
            p = partService.createPart(partId);
            partStack.getChildren().add(p);
            partStack.setSelectedElement((MUIElement)p);
        }
        if (pageId != null) {
            p.getPersistedState().put("org.xmind.ui.modelPart.currentPageId", pageId);
        }
        appli.getContext().set("org.xmind.ui.modelPart.lastOpened", (Object)partId);
        if (!partStackExisted) {
            ((MWindow)appli.getChildren().get(0)).getChildren().add(p);
        }
        partStack.setVisible(true);
        p.setVisible(true);
        modelService.bringToTop((MUIElement)p);
        partService.activate(p, true);
    }

    private MPartStack createPartStack(EModelService modelService, String partStackId) {
        MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        partStack.setElementId(partStackId);
        partStack.setVisible(true);
        return partStack;
    }

    @CanExecute
    public boolean canExecute(MApplication app, EModelService modelService) {
        List editors = modelService.findElements((MUIElement)app, null, MPart.class, Arrays.asList("Editor"));
        return !editors.isEmpty();
    }
}

