/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.novamind;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IImage;
import org.xmind.core.INotesContent;
import org.xmind.core.INumbering;
import org.xmind.core.IParagraph;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.novamind.NMConstants;
import org.xmind.ui.internal.imports.novamind.NovaMindResourceMappingManager;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovaMindImporter
extends MindMapImporter
implements NMConstants,
ErrorHandler {
    private static final Pattern DATE_PATTERN = Pattern.compile("((\\d+)-(\\d{1,2})-(\\d{1,2}))T((\\d{1,2}):(\\d{1,2}):(\\d{1,2}))");
    private static final String TRANSPARENT_VALUE = "0.00";
    private static final double DPM = 1.0;
    private static final String CONTENT_XML = "content.xml";
    private static final String MANIFEST_XML = "manifest.xml";
    private static final String STYLE_SHEET_XML = "style-sheet.xml";
    private static final String SEP = File.separator;
    private static final String RESOURCES_FOLDER = "Resources" + SEP;
    private static ResourceMappingManager mappings = null;
    private IStorage tempStorage;
    private IInputSource tempSource;
    private Document content;
    private Document manifest;
    private Document styleSheet;
    private ISheet targetSheet;
    private Map<IStyled, IStyle> styleMap = new HashMap<IStyled, IStyle>(30);
    private IStyle theme = null;
    private IStyleSheet tempStyleSheet = null;
    private Map<String, String> topicIdMap = new HashMap<String, String>(30);
    private Map<String, String> refIdMap = new HashMap<String, String>(30);
    private Map<String, List<ITopic>> topicLinkMap = new HashMap<String, List<ITopic>>(10);
    private Map<String, Element> resourceRefMap = new HashMap<String, Element>();
    private Map<String, String> resourceMap = new HashMap<String, String>(30);
    private Map<String, Element> themeRefMap = new HashMap<String, Element>();
    private Map<String, String> assignRefMap = new HashMap<String, String>();

    private NovaMindImporter(String sourcePath) {
        super(sourcePath);
    }

    public NovaMindImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromNovaCount");
        this.getMonitor().beginTask(null, 100);
        try {
            try {
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ReadingContent);
                this.tempStorage = this.createTemporaryStorage();
                this.extractSourceFileToTemporaryStorage();
                this.tempSource = this.tempStorage.getInputSource();
                this.content = this.readFile(CONTENT_XML);
                this.manifest = this.readFile(MANIFEST_XML);
                this.styleSheet = this.readFile(STYLE_SHEET_XML);
                this.getMonitor().worked(45);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ReadingElements);
                this.loadWorkbook(this.content.getDocumentElement());
                this.setTopicLinks();
                this.getMonitor().worked(45);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ArrangingStyles);
                this.arrangeStyles();
                this.getMonitor().worked(5);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_GeneratingTheme);
                this.generateTheme();
                this.getMonitor().worked(5);
                this.getMonitor().done();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.clearTempStorage();
        }
        this.postBuilded();
    }

    private Document readFile(String name) throws Exception {
        Document doc;
        InputStream docEntryStream = this.tempSource.getEntryStream(name);
        if (docEntryStream == null) {
            throw new IOException("No content entry");
        }
        DocumentBuilder builder = NovaMindImporter.getDocumentBuilder();
        builder.setErrorHandler(this);
        MonitoredInputStream in = new MonitoredInputStream(docEntryStream, this.getMonitor());
        try {
            doc = builder.parse((InputStream)in);
        }
        catch (Throwable throwable) {
            builder.setErrorHandler(null);
            try {
                in.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        builder.setErrorHandler(null);
        try {
            in.close();
        }
        catch (Exception exception) {}
        return doc;
    }

    private IStorage createTemporaryStorage() throws IOException {
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        File tempDir = FileUtils.ensureDirectory((File)new File(Core.getWorkspace().getTempDir("import/mindmanager"), id));
        return new DirectoryStorage(tempDir);
    }

    private void extractSourceFileToTemporaryStorage() throws IOException, CoreException {
        FileInputStream fin = new FileInputStream(this.getSourcePath());
        try {
            ZipInputStream zin = new ZipInputStream((InputStream)new MonitoredInputStream((InputStream)new BufferedInputStream(fin), this.getMonitor()));
            try {
                FileUtils.extractZipFile((ZipInputStream)zin, (IOutputTarget)this.tempStorage.getOutputTarget());
            }
            finally {
                zin.close();
            }
        }
        finally {
            fin.close();
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void clearTempStorage() {
        if (this.tempStorage != null) {
            this.tempStorage.clear();
            this.tempStorage = null;
        }
    }

    private void loadWorkbook(Element docEle) throws InterruptedException {
        this.checkInterrupted();
        Element workbookEle = NovaMindImporter.child(docEle, "maps");
        if (workbookEle == null) {
            return;
        }
        Element sheetEle = NovaMindImporter.child(workbookEle, "map");
        if (sheetEle == null) {
            return;
        }
        this.loadSheet(sheetEle);
    }

    private void loadSheet(Element sheetEle) throws InterruptedException {
        String themeRef;
        Element themeEle;
        Element relationshipsEle;
        this.checkInterrupted();
        this.targetSheet = this.getTargetWorkbook().createSheet();
        this.targetSheet.setTitleText(this.getSuggestedSheetTitle());
        Element topicEle = NovaMindImporter.child(sheetEle, "topic-node");
        if (topicEle != null) {
            this.loadRootTopic(topicEle);
        }
        if ((relationshipsEle = NovaMindImporter.child(sheetEle, "link-lines")) != null) {
            this.loadRelationships(relationshipsEle);
        }
        if ((themeEle = this.findThemeEle(themeRef = NovaMindImporter.att(sheetEle, "theme-ref"))) != null) {
            this.loadTheme(themeEle);
        }
        this.addTargetSheet(this.targetSheet);
    }

    public ISheet getTargetSheet() {
        return this.targetSheet;
    }

    private void loadRootTopic(Element topicEle) throws InterruptedException {
        this.checkInterrupted();
        ITopic rootTopic = this.getTargetSheet().getRootTopic();
        this.loadTopic(topicEle, rootTopic);
        Element subTopicsEle = NovaMindImporter.child(topicEle, "sub-topics");
        if (subTopicsEle != null) {
            this.loadSubElements(subTopicsEle, rootTopic);
        }
    }

    private void loadSubElements(Element topicsEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> subElements = NovaMindImporter.children(topicsEle, "topic-node");
        while (subElements.hasNext()) {
            Element subElement = subElements.next();
            String type = NovaMindImporter.att(subElement, "type");
            if ("Boundary".equals(type)) {
                this.loadBoundary(subElement, topic);
                continue;
            }
            ITopic subTopic = this.addElement(topic, subElement, type);
            this.loadTopic(subElement, subTopic);
            Element subTopicsEle = NovaMindImporter.child(subElement, "sub-topics");
            if (subTopicsEle == null) continue;
            this.loadSubElements(subTopicsEle, subTopic);
        }
    }

    private void loadTopic(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        this.loadOId(topicEle, (IIdentifiable)topic);
        this.loadTopicContent(topicEle, topic);
        this.loadTopicNodeStyle(topicEle, topic);
    }

    private ITopic addElement(ITopic topic, Element topicEle, String type) {
        ITopic subTopic = this.getTargetWorkbook().createTopic();
        if ("FloatingTopic".equals(type)) {
            topic.add(subTopic, "detached");
        } else if ("Callout".equals(type)) {
            topic.add(subTopic, "callout");
        } else {
            topic.add(subTopic);
        }
        return subTopic;
    }

    private void loadOId(Element nmEle, IIdentifiable element) {
        String OId = NovaMindImporter.att(nmEle, "id");
        if (OId != null) {
            this.topicIdMap.put(OId, element.getId());
        }
    }

    private void loadTopicContent(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        String id = NovaMindImporter.att(topicEle, "id");
        String ref = NovaMindImporter.att(topicEle, "topic-ref");
        this.refIdMap.put(ref, id);
        Element contentEle = this.findTopicContentEle(ref);
        if (contentEle == null) {
            return;
        }
        this.loadTitleText(contentEle, topic);
        this.loadNotes(contentEle, topic);
        this.loadHyperlink(contentEle, topic);
        this.loadAttachments(contentEle, topic);
        this.loadImages(contentEle, topic);
        this.loadTask(contentEle, topic);
    }

    private Element findTopicContentEle(String refId) throws InterruptedException {
        this.checkInterrupted();
        if (refId == null) {
            return null;
        }
        Element contentEle = this.content.getDocumentElement();
        Element topicsEle = NovaMindImporter.child(contentEle, "topics");
        if (topicsEle == null) {
            return null;
        }
        Iterator<Element> topicEles = NovaMindImporter.children(topicsEle, "topic");
        while (topicEles.hasNext()) {
            Element topic = topicEles.next();
            String id = NovaMindImporter.att(topic, "id");
            if (!refId.equals(id)) continue;
            return topic;
        }
        return null;
    }

    private void loadTitleText(Element contentEle, ITopic topic) throws InterruptedException {
        Element text = NovaMindImporter.child(contentEle, "rich-text");
        if (text == null) {
            return;
        }
        Element titleRun = NovaMindImporter.child(text, "text-run");
        if (titleRun == null) {
            return;
        }
        topic.setTitleText(titleRun.getTextContent());
        this.loadTextStyle(titleRun, (IStyled)topic);
    }

    private void loadNotes(Element contentEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element notesEle = NovaMindImporter.child(contentEle, "notes");
        if (notesEle == null) {
            return;
        }
        IHtmlNotesContent content = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
        NotesImporter notesImporter = new NotesImporter(content);
        notesImporter.loadFrom(notesEle);
        topic.getNotes().setContent("html", (INotesContent)content);
    }

    private void loadHyperlink(Element contentEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element linksEle = NovaMindImporter.child(contentEle, "links");
        if (linksEle == null) {
            return;
        }
        Iterator<Element> it = NovaMindImporter.children(linksEle, "link");
        while (it.hasNext()) {
            Element linkDataEle = it.next();
            String url = NovaMindImporter.att(linkDataEle, "url");
            if (url == null) continue;
            String name = NovaMindImporter.att(linkDataEle, "display-name");
            if (name == null || "".equals(name)) {
                name = url;
            }
            ITopic linkTopic = this.getTargetWorkbook().createTopic();
            linkTopic.setTitleText(name);
            topic.add(linkTopic);
            if (url.startsWith("novamind://topic/")) {
                this.recordTopicLink(url.replace("novamind://topic/", ""), linkTopic);
                continue;
            }
            if (!HyperlinkUtils.isLinkToWeb((String)url)) {
                url = FilePathParser.toURI((String)url, (boolean)false);
            }
            linkTopic.setHyperlink(url);
        }
    }

    private void loadAttachments(Element contentEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        if (this.manifest == null) {
            return;
        }
        Element attachmentsEle = NovaMindImporter.child(contentEle, "attachments");
        if (attachmentsEle == null) {
            return;
        }
        Iterator<Element> attachmentEles = NovaMindImporter.children(attachmentsEle, "attachment");
        while (attachmentEles.hasNext()) {
            Element attDataEle = attachmentEles.next();
            IFileEntry entry = this.getResourceFileEntry(attDataEle);
            if (entry == null) continue;
            ITopic attTopic = this.getTargetWorkbook().createTopic();
            String title = this.getResourceTitle(attDataEle);
            attTopic.setTitleText(title == null ? new File(entry.getPath()).getName() : title);
            attTopic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
            topic.add(attTopic, "attached");
        }
    }

    private void loadImages(Element contentEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        if (this.manifest == null) {
            return;
        }
        this.loadImage(contentEle, topic, "top-image", "top", 0, 64);
        this.loadImage(contentEle, topic, "bottom-image", "bottom", 0, 64);
        this.loadImage(contentEle, topic, "left-image", "left", 64, 0);
        this.loadImage(contentEle, topic, "right-image", "right", 64, 0);
    }

    private void loadImage(Element contentEle, ITopic topic, String imageAtt, String alignment, int w, int h) throws InterruptedException {
        IFileEntry entry;
        Element imageEle = NovaMindImporter.child(contentEle, imageAtt);
        if (imageEle != null && (entry = this.getResourceFileEntry(imageEle)) != null) {
            String title = this.getResourceTitle(imageEle);
            ITopic attTopic = this.getTargetWorkbook().createTopic();
            attTopic.setTitleText(title == null ? new File(entry.getPath()).getName() : title);
            IImage image = attTopic.getImage();
            image.setSource(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
            image.setAlignment(alignment);
            image.setSize(w == 0 ? -1 : w, h == 0 ? -1 : h);
            topic.add(attTopic);
        }
    }

    private void loadTask(Element contentEle, ITopic topic) throws InterruptedException {
        Element resourcesEle;
        Matcher m;
        String end;
        Matcher m2;
        String start;
        this.checkInterrupted();
        Element taskEle = NovaMindImporter.child(contentEle, "project-task");
        if (taskEle == null) {
            return;
        }
        ITopicExtensionElement taskContent = null;
        String priority = NovaMindImporter.att(taskEle, "priority");
        this.loadMarker(topic, NovaMindImporter.parsePriority(priority));
        String pc = NovaMindImporter.att(taskEle, "percentage-complete");
        this.loadMarker(topic, NovaMindImporter.parsePercentage(pc));
        if (pc != null) {
            taskContent = NovaMindImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("progress");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("progress");
            ele.setTextContent(pc);
        }
        if ((start = NovaMindImporter.att(taskEle, "start-time")) != null && !"".equals(start) && (m2 = DATE_PATTERN.matcher(start)).find()) {
            taskContent = NovaMindImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("start-date");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("start-date");
            ele.setTextContent(String.valueOf(m2.group(1)) + " " + m2.group(5));
        }
        if ((end = NovaMindImporter.att(taskEle, "end-time")) != null && (m = DATE_PATTERN.matcher(end)).find()) {
            taskContent = NovaMindImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("end-date");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("end-date");
            ele.setTextContent(String.valueOf(m.group(1)) + " " + m.group(5));
        }
        String duration = NovaMindImporter.att(taskEle, "duration");
        String dUnit = NovaMindImporter.att(taskEle, "duration-unit");
        if (duration != null && !"".equals(duration)) {
            String durationLabel = null;
            durationLabel = "Years".equals(dUnit) ? NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Years_label, (Object)duration) : ("Months".equals(dUnit) ? NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Months_label, (Object)duration) : ("Weeks".equals(dUnit) ? NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Weeks_label, (Object)duration) : ("Hours".equals(dUnit) ? NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Hours_label, (Object)duration) : ("Minutes".equals(dUnit) ? NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Minutes_label, (Object)duration) : NLS.bind((String)ImportMessages.NovaMindImporter_Duration_Days_label, (Object)duration)))));
            topic.addLabel(NLS.bind((String)ImportMessages.NovaMindImporter_Duration_label, (Object)durationLabel));
        }
        if ((resourcesEle = NovaMindImporter.child(taskEle, "assigned-resources")) != null) {
            Iterator<Element> it = NovaMindImporter.children(resourcesEle, "project-resource-ref");
            String assigns = "";
            while (it.hasNext()) {
                Element next = it.next();
                String ref = next.getTextContent();
                assigns = String.valueOf(assigns) + this.findAssign(ref) + ",";
            }
            if (assigns != null && !"".equals(assigns)) {
                assigns = assigns.substring(0, assigns.length() - 2);
                taskContent = NovaMindImporter.ensureTaskContent(topic, taskContent);
                taskContent.deleteChildren("assigned-to");
                ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("assigned-to");
                ele.setTextContent(assigns);
                topic.addLabel(NLS.bind((String)ImportMessages.NovaMindImporter_Resource_label, (Object)assigns.replaceAll(",", ";")));
            }
        }
    }

    private void loadMarker(ITopic topic, String markerId) throws InterruptedException {
        this.checkInterrupted();
        if (markerId != null) {
            topic.addMarker(markerId);
        }
    }

    private static String parsePriority(String nmPriority) {
        if (nmPriority == null) {
            return null;
        }
        try {
            int priority = Integer.parseInt(nmPriority);
            switch (priority) {
                case 1: {
                    return "priority-1";
                }
                case 2: {
                    return "priority-2";
                }
                case 3: {
                    return "priority-3";
                }
                case 4: {
                    return "priority-4";
                }
                case 5: {
                    return "priority-5";
                }
                case 6: {
                    return "priority-6";
                }
                case 7: {
                    return "priority-7";
                }
                case 8: {
                    return "priority-8";
                }
                case 9: {
                    return "priority-9";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private static String parsePercentage(String nmPercentage) {
        int pc;
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        if (nmPercentage == null) {
                                            return null;
                                        }
                                        try {
                                            pc = Integer.parseInt(nmPercentage);
                                            if (pc >= 12) break block12;
                                            return "task-start";
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    if (pc >= 25) break block13;
                                    return "task-oct";
                                }
                                if (pc >= 37) break block14;
                                return "task-quarter";
                            }
                            if (pc >= 50) break block15;
                            return "task-3oct";
                        }
                        if (pc >= 62) break block16;
                        return "task-half";
                    }
                    if (pc >= 75) break block17;
                    return "task-5oct";
                }
                if (pc >= 87) break block18;
                return "task-3quar";
            }
            if (pc >= 100) break block19;
            return "task-7oct";
        }
        if (pc == 100) {
            return "task-done";
        }
        return null;
    }

    private void loadTextStyle(Element titleEle, IStyled host) throws InterruptedException {
        String fontName;
        this.checkInterrupted();
        String nmColor = NovaMindImporter.att(titleEle, "font-color");
        if (nmColor != null) {
            nmColor = this.realNmColor(nmColor);
            this.registerStyle(host, "fo:color", NovaMindImporter.parseColor(nmColor.substring(3)));
        }
        this.registerStyle(host, "fo:font-size", NovaMindImporter.parseFontSize(NovaMindImporter.att(titleEle, "font-size")));
        this.registerStyle(host, "fo:font-weight", Boolean.parseBoolean(NovaMindImporter.att(titleEle, "bold")) ? "bold" : null);
        this.registerStyle(host, "fo:font-style", Boolean.parseBoolean(NovaMindImporter.att(titleEle, "italic")) ? "italic" : null);
        String textDecoration = StyleUtils.toTextDecoration((NovaMindImporter.att(titleEle, "underline-style") != null ? 1 : 0) != 0, (NovaMindImporter.att(titleEle, "strikethrough-style") != null ? 1 : 0) != 0);
        this.registerStyle(host, "fo:text-decoration", textDecoration);
        String alignment = NovaMindImporter.att(titleEle, "alignment");
        if (alignment != null) {
            this.registerStyle(host, "fo:text-align", alignment.toLowerCase());
        }
        if ((fontName = NovaMindImporter.att(titleEle, "mac-font-name")) == null) {
            fontName = NovaMindImporter.att(titleEle, "windows-font-name");
        }
        if (fontName != null) {
            String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
            fontName = availableFontName != null ? availableFontName : fontName;
            this.registerStyle(host, "fo:font-family", fontName);
        }
    }

    private void loadTopicNodeStyle(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element nodeViewEle = NovaMindImporter.child(topicEle, "topic-node-view");
        if (nodeViewEle == null) {
            return;
        }
        this.loadPosition(nodeViewEle, topic);
        Element nodeStyleEle = NovaMindImporter.child(nodeViewEle, "topic-node-style");
        if (nodeStyleEle == null) {
            return;
        }
        this.loadFillStyle(nodeStyleEle, (IStyled)topic, null);
        this.loadShapeStyle(nodeStyleEle, (IStyled)topic);
        this.loadLineStyle(nodeStyleEle, (IStyled)topic);
        this.loadStructure(nodeStyleEle, topic);
        this.loadConnectionStyle(nodeStyleEle, topic);
        this.loadNumbering(nodeStyleEle, topic);
    }

    private void loadPosition(Element nodeViewEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        String location = NovaMindImporter.att(nodeViewEle, "manual-location");
        if ((location == null || "".equals(location)) && ("detached".equals(topic.getType()) || "callout".equals(topic.getType()))) {
            location = NovaMindImporter.att(nodeViewEle, "location");
        }
        if (location == null || "".equals(location)) {
            return;
        }
        String[] split = location.split(",");
        if (split.length != 2) {
            return;
        }
        Float x = NovaMindImporter.parseFloat(split[0]);
        Float y = NovaMindImporter.parseFloat(split[1]);
        if (x != null && y != null && x.floatValue() != 0.0f && y.floatValue() != 0.0f) {
            topic.setPosition(NovaMindImporter.mm2Dots(x.floatValue()), NovaMindImporter.mm2Dots(y.floatValue()));
        }
    }

    private void loadFillStyle(Element nodeStyleEle, IStyled host, String defaultColor) throws InterruptedException {
        this.checkInterrupted();
        Element fillStyleEle = NovaMindImporter.child(nodeStyleEle, "fill-style");
        if (fillStyleEle == null) {
            return;
        }
        String nmColor = this.getFillValue(fillStyleEle);
        if (nmColor == null) {
            if (defaultColor == null) {
                return;
            }
            nmColor = defaultColor;
        }
        nmColor = this.realNmColor(nmColor);
        String opacity = this.parseAlpha(nmColor);
        String fillColor = NovaMindImporter.parseColor(nmColor.substring(3));
        if (opacity != null && !opacity.equals(TRANSPARENT_VALUE)) {
            this.registerStyle(host, "svg:opacity", opacity);
        }
        if (fillColor != null) {
            this.registerStyle(host, "svg:fill", fillColor);
        }
    }

    private String realNmColor(String nmColor) {
        if (!nmColor.startsWith("#")) {
            nmColor = NovaMindImporter.getMapping("nmColor", nmColor, "#FFFFF");
        }
        return nmColor;
    }

    private String getFillValue(Element fillStyleEle) throws InterruptedException {
        Element solidColorEle;
        Element simpleGradientEle;
        Element colorEle;
        Element advancedColors;
        this.checkInterrupted();
        String fillValue = null;
        Element advancedGradientEle = NovaMindImporter.child(fillStyleEle, "advanced-gradient");
        if (advancedGradientEle != null && (advancedColors = NovaMindImporter.child(advancedGradientEle, "colors")) != null && (colorEle = NovaMindImporter.child(advancedColors, "color-stop")) != null) {
            fillValue = NovaMindImporter.att(colorEle, "color");
        }
        if (fillValue == null && (simpleGradientEle = NovaMindImporter.child(fillStyleEle, "simple-gradient")) != null) {
            String sColor = NovaMindImporter.att(simpleGradientEle, "start-color");
            String eColor = NovaMindImporter.att(simpleGradientEle, "end-color");
            String string = fillValue = sColor != null ? sColor : eColor;
        }
        if (fillValue == null && (solidColorEle = NovaMindImporter.child(fillStyleEle, "solid-color")) != null) {
            fillValue = NovaMindImporter.att(solidColorEle, "color");
        }
        return fillValue;
    }

    private String parseAlpha(String color) {
        if (color != null && color.startsWith("#")) {
            try {
                int alpha = Integer.parseInt(color.substring(1, 2), 16);
                double opacity = (double)alpha * 100.0 / 255.0;
                return String.format("%.2f", opacity);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static String parseColor(String color) {
        if (color != null) {
            try {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return ColorUtils.toString((int)r, (int)g, (int)b);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private static String parseFontSize(String size) {
        if (size != null) {
            try {
                double value = Double.parseDouble(size);
                size = StyleUtils.addUnitPoint((int)((int)value));
            }
            catch (Exception exception) {}
        }
        return size;
    }

    private void loadShapeStyle(Element nodeStyleEle, IStyled host) throws InterruptedException {
        Element boundaryShapeEle;
        Element topicShapeEle;
        this.checkInterrupted();
        Element shapeStyleEle = NovaMindImporter.child(nodeStyleEle, "shape-style");
        if (shapeStyleEle == null) {
            return;
        }
        if (host instanceof ITopic && (topicShapeEle = NovaMindImporter.child(shapeStyleEle, "topic-shape-style")) != null) {
            String shape = NovaMindImporter.att(topicShapeEle, "type");
            if ("callout".equals(((ITopic)host).getType())) {
                this.registerStyle(host, "callout-shape-class", NovaMindImporter.parseCalloutShape(shape));
            } else {
                this.registerStyle(host, "shape-class", NovaMindImporter.parseTopicShape(shape));
            }
        }
        if (host instanceof IBoundary && (boundaryShapeEle = NovaMindImporter.child(shapeStyleEle, "boundary-shape-style")) != null) {
            this.registerStyle(host, "shape-class", NovaMindImporter.parseBoundaryShape(NovaMindImporter.att(boundaryShapeEle, "type")));
        }
    }

    private void loadLineStyle(Element nodeStyleEle, IStyled host) throws InterruptedException {
        this.checkInterrupted();
        Element lineStyleEle = NovaMindImporter.child(nodeStyleEle, "line-style");
        if (lineStyleEle == null) {
            return;
        }
        String nmColor = NovaMindImporter.att(lineStyleEle, "color");
        if (nmColor != null) {
            nmColor = this.realNmColor(nmColor);
            this.registerStyle(host, "line-color", NovaMindImporter.parseColor(nmColor.substring(3)));
        }
        String width = NovaMindImporter.parseLineWidth(NovaMindImporter.att(lineStyleEle, "stroke-width"));
        this.registerStyle(host, "line-width", width);
        String stroke = NovaMindImporter.att(lineStyleEle, "draws-stroke");
        if (Boolean.parseBoolean(stroke)) {
            this.registerStyle(host, "border-line-width", "0");
        }
        String linePattern = NovaMindImporter.att(lineStyleEle, "dash");
        this.registerStyle(host, "line-pattern", NovaMindImporter.parseLinePattern(linePattern));
    }

    private static String parseLinePattern(String linePattern) {
        if (linePattern == null) {
            return "solid";
        }
        char c = linePattern.charAt(0);
        switch (c) {
            case 'b': 
            case 'e': 
            case 'i': 
            case 'r': {
                return "dash";
            }
            case 'c': 
            case 'f': 
            case 'l': 
            case 's': 
            case 'y': {
                return "dot";
            }
            case 'd': 
            case 'g': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 'p': 
            case 't': 
            case 'v': 
            case 'w': {
                return "dash-dot";
            }
            case 'h': 
            case 'k': 
            case 'n': 
            case 'q': 
            case 'u': 
            case 'x': {
                return "dash-dot-dot";
            }
        }
        return "solid";
    }

    private static String parseLineWidth(String width) {
        if (width == null) {
            return null;
        }
        Float w = NovaMindImporter.parseFloat(width.replace("pt", ""));
        if (w != null) {
            if (w.floatValue() <= 2.0f) {
                return "1";
            }
            if (w.floatValue() <= 4.0f) {
                return "2";
            }
            if (w.floatValue() <= 6.0f) {
                return "3";
            }
            if (w.floatValue() <= 8.0f) {
                return "4";
            }
            return "5";
        }
        return null;
    }

    private static Float parseFloat(String value) {
        if (value != null) {
            try {
                return Float.valueOf(value);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private void loadStructure(Element styleEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element layoutStyle = NovaMindImporter.child(styleEle, "children-layout-style");
        if (layoutStyle == null) {
            return;
        }
        topic.setStructureClass(NovaMindImporter.parseStructureType(topic, NovaMindImporter.att(layoutStyle, "angle"), NovaMindImporter.att(layoutStyle, "layout-mode")));
    }

    private static String parseStructureType(ITopic topic, String angle, String mode) {
        if (mode != null && mode.equalsIgnoreCase("Radial")) {
            return "org.xmind.ui.map.unbalanced";
        }
        if ("0".equals(angle)) {
            return "org.xmind.ui.logic.right";
        }
        if ("90".equals(angle)) {
            return "org.xmind.ui.org-chart.down";
        }
        if ("180".equals(angle)) {
            return "org.xmind.ui.logic.left";
        }
        if ("270".equals(angle)) {
            return "org.xmind.ui.org-chart.up";
        }
        if (topic.getParent() != null) {
            return topic.getParent().getStructureClass();
        }
        return null;
    }

    private void loadConnectionStyle(Element styleEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element connectionStyleEle = NovaMindImporter.child(styleEle, "children-connection-style");
        if (connectionStyleEle == null) {
            return;
        }
        String type = NovaMindImporter.att(connectionStyleEle, "connection-type");
        this.registerStyle((IStyled)topic, "line-class", NovaMindImporter.parseBranchConnection(type));
    }

    private static String parseBranchConnection(String lineShape) {
        return NovaMindImporter.getMapping("branchConnection", lineShape, "org.xmind.branchConnection.curve");
    }

    private void loadNumbering(Element styleEle, ITopic topic) throws InterruptedException {
        Element formatEle;
        this.checkInterrupted();
        Element numberingEle = NovaMindImporter.child(styleEle, "children-outline-numbering-style");
        if (numberingEle == null) {
            return;
        }
        String depthValue = NovaMindImporter.att(numberingEle, "depth");
        if (depthValue == null || "".equals(depthValue)) {
            return;
        }
        INumbering numbering = topic.getNumbering();
        if ("0".equals(depthValue)) {
            numbering.setFormat("org.xmind.numbering.none");
            return;
        }
        int depth = Integer.parseInt(depthValue);
        depth = depth == -1 ? 10 : depth;
        String format = "org.xmind.numbering.arabic";
        String separator = "org.xmind.numbering.separator.dot";
        String prefix = null;
        String suffix = null;
        Element formatArrayEle = NovaMindImporter.child(numberingEle, "format-array");
        if (formatArrayEle != null && (formatEle = NovaMindImporter.child(formatArrayEle, "outline-format")) != null) {
            format = NovaMindImporter.parseNumberFormat(NovaMindImporter.att(formatEle, "style"));
            separator = NovaMindImporter.parseNumberSeprator(NovaMindImporter.att(formatEle, "separator"));
            prefix = NovaMindImporter.att(formatEle, "prefix");
            suffix = NovaMindImporter.att(formatEle, "suffix");
        }
        numbering.setFormat(format);
        numbering.setSeparator(separator);
        numbering.setDepth(String.valueOf(depth));
        if (prefix != null) {
            numbering.setPrefix(prefix);
        }
        if (suffix != null) {
            numbering.setSuffix(suffix);
        }
    }

    private static String parseNumberFormat(String format) {
        return NovaMindImporter.getMapping("numberFormat", format, "org.xmind.numbering.arabic");
    }

    private static String parseNumberSeprator(String seprator) {
        return NovaMindImporter.getMapping("numberSeprator", seprator, "org.xmind.numbering.separator.dot");
    }

    private void loadBoundary(Element boundaryEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        if (topic.isRoot()) {
            return;
        }
        IBoundary boundary = this.getTargetWorkbook().createBoundary();
        if (topic.isAttached()) {
            ITopic parent = topic.getParent();
            int index = topic.getIndex();
            boundary.setStartIndex(index);
            boundary.setEndIndex(index);
            parent.addBoundary(boundary);
        } else {
            boundary.setMasterBoundary(true);
            topic.addBoundary(boundary);
        }
        this.loadBoundaryStyle(boundaryEle, boundary);
    }

    private void loadBoundaryStyle(Element boundaryEle, IBoundary boundary) throws InterruptedException {
        this.checkInterrupted();
        Element nodeViewEle = NovaMindImporter.child(boundaryEle, "topic-node-view");
        if (nodeViewEle == null) {
            return;
        }
        Element nodeStyleEle = NovaMindImporter.child(nodeViewEle, "topic-node-style");
        if (nodeStyleEle == null) {
            return;
        }
        this.loadFillStyle(nodeStyleEle, (IStyled)boundary, "#fffce0bf");
        this.loadLineStyle(nodeStyleEle, (IStyled)boundary);
        this.loadShapeStyle(nodeStyleEle, (IStyled)boundary);
    }

    private void loadRelationships(Element relationshipsEle) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> relationshipEles = NovaMindImporter.children(relationshipsEle, "topic-node");
        while (relationshipEles.hasNext()) {
            this.loadRelationship(relationshipEles.next());
        }
    }

    private void loadRelationship(Element relationshipEle) throws InterruptedException {
        this.checkInterrupted();
        Element relDataEle = NovaMindImporter.child(relationshipEle, "link-line-data");
        if (relDataEle == null) {
            return;
        }
        IRelationship rel = this.getTargetWorkbook().createRelationship();
        this.getTargetSheet().addRelationship(rel);
        this.loadConnections(relDataEle, rel, true);
        Element nodeViewEle = NovaMindImporter.child(relationshipEle, "topic-node-view");
        if (nodeViewEle == null) {
            return;
        }
        Element styleEle = NovaMindImporter.child(nodeViewEle, "topic-node-style");
        if (styleEle == null) {
            return;
        }
        this.loadLineStyle(styleEle, (IStyled)rel);
    }

    private void loadConnections(Element relDataEle, IRelationship rel, boolean autoRouting) throws InterruptedException {
        Element endStyleEle;
        Element startStyleEle;
        this.checkInterrupted();
        String startOId = NovaMindImporter.att(relDataEle, "start-topic-node-ref");
        String endOId = NovaMindImporter.att(relDataEle, "end-topic-node-ref");
        String startId = this.topicIdMap.get(startOId);
        String endId = this.topicIdMap.get(endOId);
        if (startId != null && endId != null) {
            rel.setEnd1Id(startId);
            rel.setEnd2Id(endId);
        }
        if ((startStyleEle = NovaMindImporter.child(relDataEle, "start-terminator")) != null) {
            this.registerStyle((IStyled)rel, "arrow-begin-class", this.parseRelTerminatorType(NovaMindImporter.att(startStyleEle, "type")));
        }
        if ((endStyleEle = NovaMindImporter.child(relDataEle, "end-terminator")) != null) {
            this.registerStyle((IStyled)rel, "arrow-end-class", this.parseRelTerminatorType(NovaMindImporter.att(endStyleEle, "type")));
        }
    }

    private String parseRelTerminatorType(String type) {
        return NovaMindImporter.getMapping("arrowShape", type, null);
    }

    private static String parseTopicShape(String nmShape) {
        return NovaMindImporter.getMapping("topicShape", nmShape, null);
    }

    private static String parseCalloutShape(String nmShape) {
        return NovaMindImporter.getMapping("calloutShape", nmShape, null);
    }

    private static String parseBoundaryShape(String nmShape) {
        return NovaMindImporter.getMapping("boundaryShape", nmShape, "org.xmind.boundaryShape.polygon");
    }

    private void registerStyle(IStyled styleOwner, String key, String value) {
        String oldValue;
        if (value == null) {
            return;
        }
        IStyle style = this.styleMap.get(styleOwner);
        if (style == null) {
            style = this.getTempStyleSheet().createStyle(styleOwner.getStyleType());
            this.getTempStyleSheet().addStyle(style, "normal-styles");
            this.styleMap.put(styleOwner, style);
        }
        if ("fo:text-decoration".equals(key) && (oldValue = style.getProperty(key)) != null && !oldValue.contains(value)) {
            boolean underline = oldValue.contains("underline") || value.contains("underline");
            boolean strikeout = oldValue.contains("line-through") || value.contains("line-through");
            value = StyleUtils.toTextDecoration((boolean)underline, (boolean)strikeout);
        }
        style.setProperty(key, value);
    }

    private IStyleSheet getTempStyleSheet() {
        if (this.tempStyleSheet == null) {
            this.tempStyleSheet = Core.getStyleSheetBuilder().createStyleSheet();
            ((StyleSheetImpl)this.tempStyleSheet).setManifest(this.getTargetWorkbook().getManifest());
        }
        return this.tempStyleSheet;
    }

    private void arrangeStyles() throws InterruptedException {
        IStyleSheet targetStyleSheet = this.getTargetWorkbook().getStyleSheet();
        for (Map.Entry<IStyled, IStyle> en : this.styleMap.entrySet()) {
            this.checkInterrupted();
            IStyled styleOwner = en.getKey();
            IStyle style = en.getValue();
            IStyle importedStyle = targetStyleSheet.importStyle(style);
            if (importedStyle == null) continue;
            styleOwner.setStyleId(importedStyle.getId());
        }
    }

    private void loadTheme(Element themeEle) throws InterruptedException {
        this.checkInterrupted();
        this.loadSheetStyle(themeEle);
        this.loadTopicTheme(themeEle);
        this.loadRelTheme(themeEle);
        this.loadBoundaryTheme(themeEle);
    }

    private void loadSheetStyle(Element themeEle) throws InterruptedException {
        IFileEntry entry;
        Element bgImageEle;
        String nmColor;
        this.checkInterrupted();
        Element styleEle = NovaMindImporter.child(themeEle, "background-style");
        if (styleEle == null) {
            return;
        }
        ISheet sheet = this.getTargetSheet();
        this.registerStyle((IStyled)sheet, "line-tapered", "tapered");
        Element bgFillEle = NovaMindImporter.child(styleEle, "solid-color");
        if (bgFillEle != null && (nmColor = NovaMindImporter.att(bgFillEle, "color")) != null) {
            this.registerStyle((IStyled)sheet, "svg:fill", NovaMindImporter.parseColor(this.realNmColor(nmColor).substring(3)));
        }
        if ((bgImageEle = NovaMindImporter.child(styleEle, "texture-image")) != null && (entry = this.getResourceFileEntry(bgImageEle)) != null && entry.getSize() > 0L) {
            this.registerStyle((IStyled)sheet, "background", HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
            this.registerStyle((IStyled)sheet, "svg:opacity", NovaMindImporter.att(bgImageEle, "opacity"));
        }
    }

    private void loadTopicTheme(Element themeEle) throws InterruptedException {
        Element calloutStyleEle;
        Element floatStyleEle;
        this.checkInterrupted();
        Element rootStyleEle = NovaMindImporter.child(themeEle, "root-topic-style");
        if (rootStyleEle != null) {
            this.loadTopicTheme(rootStyleEle, "centralTopic", true);
        }
        if ((floatStyleEle = NovaMindImporter.child(themeEle, "floating-topic-style")) != null) {
            this.loadTopicTheme(floatStyleEle, "floatingTopic", false);
        }
        if ((calloutStyleEle = NovaMindImporter.child(themeEle, "callout-style")) != null) {
            this.loadTopicTheme(calloutStyleEle, "calloutTopic", false);
        }
    }

    private void loadTopicTheme(Element parentEle, String styleFamily, boolean withChildren) throws InterruptedException {
        this.checkInterrupted();
        this.loadThemeFill(parentEle, "topic", styleFamily);
        this.loadThemeLineStyle(parentEle, "topic", styleFamily);
        this.loadThemeShapeStyle(parentEle, "topic", styleFamily);
        this.loadThemeTextStyle(parentEle, "topic", styleFamily);
        Element childEle = NovaMindImporter.child(parentEle, "children-default-style");
        if (withChildren && childEle != null) {
            this.loadTopicTheme(childEle, "subTopic", false);
        }
    }

    private void loadThemeFill(Element parentEle, String type, String styleFamily) throws InterruptedException {
        String nmColor;
        this.checkInterrupted();
        Element fillStyleEle = NovaMindImporter.child(parentEle, "fill-style");
        if (fillStyleEle != null && (nmColor = this.getFillValue(fillStyleEle)) != null) {
            nmColor = this.realNmColor(nmColor);
            String fillColor = NovaMindImporter.parseColor(nmColor.substring(3));
            this.registerTheme(type, styleFamily, "svg:fill", fillColor);
        }
    }

    private void loadThemeTextStyle(Element parentEle, String type, String styleFamily) throws InterruptedException {
        String fontName;
        this.checkInterrupted();
        Element textEle = NovaMindImporter.child(parentEle, "text-style");
        if (textEle == null) {
            return;
        }
        String nmColor = NovaMindImporter.att(textEle, "font-color");
        if (nmColor != null) {
            nmColor = this.realNmColor(nmColor);
            this.registerTheme(type, styleFamily, "fo:color", NovaMindImporter.parseColor(nmColor.substring(3)));
        }
        this.registerTheme(type, styleFamily, "fo:font-size", NovaMindImporter.parseFontSize(NovaMindImporter.att(textEle, "font-size")));
        this.registerTheme(type, styleFamily, "fo:font-weight", Boolean.parseBoolean(NovaMindImporter.att(textEle, "bold")) ? "bold" : null);
        this.registerTheme(type, styleFamily, "fo:font-style", Boolean.parseBoolean(NovaMindImporter.att(textEle, "italic")) ? "italic" : null);
        String textDecoration = StyleUtils.toTextDecoration((NovaMindImporter.att(textEle, "underline-style") != null ? 1 : 0) != 0, (NovaMindImporter.att(textEle, "strikethrough-style") != null ? 1 : 0) != 0);
        this.registerTheme(type, styleFamily, "fo:text-decoration", textDecoration);
        String alignment = NovaMindImporter.att(textEle, "alignment");
        if (alignment != null) {
            this.registerTheme(type, styleFamily, "fo:text-align", alignment.toLowerCase());
        }
        if ((fontName = NovaMindImporter.att(textEle, "mac-font-name")) == null) {
            fontName = NovaMindImporter.att(textEle, "windows-font-name");
        }
        if (fontName != null) {
            String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
            fontName = availableFontName != null ? availableFontName : fontName;
            this.registerTheme(type, styleFamily, "fo:font-family", fontName);
        }
    }

    private void loadThemeLineStyle(Element parentEle, String type, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element lineStyleEle = NovaMindImporter.child(parentEle, "line-style");
        if (lineStyleEle == null) {
            return;
        }
        String nmColor = NovaMindImporter.att(lineStyleEle, "color");
        if (nmColor != null) {
            nmColor = this.realNmColor(nmColor);
            this.registerTheme(type, styleFamily, "line-color", nmColor);
        }
        String width = NovaMindImporter.parseLineWidth(NovaMindImporter.att(lineStyleEle, "stroke-width"));
        this.registerTheme(type, styleFamily, "line-width", width);
        String stroke = NovaMindImporter.att(lineStyleEle, "draws-stroke");
        if (Boolean.parseBoolean(stroke)) {
            this.registerTheme(type, styleFamily, "border-line-width", "0");
        }
        String linePattern = NovaMindImporter.att(lineStyleEle, "dash");
        this.registerTheme(type, styleFamily, "line-pattern", linePattern);
    }

    private void loadThemeShapeStyle(Element parentEle, String type, String styleFamily) throws InterruptedException {
        Element boundaryShapeEle;
        Element topicShapeEle;
        this.checkInterrupted();
        Element shapeStyleEle = NovaMindImporter.child(parentEle, "shape-style");
        if (shapeStyleEle == null) {
            return;
        }
        if ("topic".equals(type) && (topicShapeEle = NovaMindImporter.child(shapeStyleEle, "topic-shape-style")) != null) {
            String shape = NovaMindImporter.att(topicShapeEle, "type");
            if ("calloutTopic".equals(styleFamily)) {
                this.registerTheme(type, styleFamily, "callout-shape-class", NovaMindImporter.parseCalloutShape(shape));
            } else {
                this.registerTheme(type, styleFamily, "shape-class", NovaMindImporter.parseTopicShape(shape));
            }
        }
        if ("boundary".equals(type) && (boundaryShapeEle = NovaMindImporter.child(shapeStyleEle, "boundary-shape-style")) != null) {
            this.registerTheme(type, styleFamily, "shape-class", NovaMindImporter.parseBoundaryShape(NovaMindImporter.att(boundaryShapeEle, "type")));
        }
    }

    private void loadRelTheme(Element themeEle) throws InterruptedException {
        this.checkInterrupted();
        Element relEle = NovaMindImporter.child(themeEle, "link-link-style");
        if (relEle == null) {
            return;
        }
        this.loadThemeLineStyle(relEle, "relationship", "relationship");
    }

    private void loadBoundaryTheme(Element themeEle) throws InterruptedException {
        this.checkInterrupted();
        Element boundaryEle = NovaMindImporter.child(themeEle, "boundary-style-1");
        if (boundaryEle == null) {
            return;
        }
        this.loadThemeShapeStyle(boundaryEle, "boundary", "boundary");
        this.loadThemeFill(boundaryEle, "boundary", "boundary");
        this.loadThemeLineStyle(boundaryEle, "boundary", "boundary");
    }

    private void registerTheme(String type, String styleFamily, String styleKey, String styleValue) throws InterruptedException {
        IStyle defaultStyle;
        this.checkInterrupted();
        if (styleFamily == null || styleKey == null || styleValue == null) {
            return;
        }
        if (this.theme == null) {
            this.theme = this.getTempStyleSheet().createStyle("theme");
            this.getTempStyleSheet().addStyle(this.theme, "master-styles");
        }
        if ((defaultStyle = this.theme.getDefaultStyle(styleFamily)) == null) {
            defaultStyle = this.getTempStyleSheet().createStyle(type);
            this.getTempStyleSheet().addStyle(defaultStyle, "automatic-styles");
        }
        defaultStyle.setProperty(styleKey, styleValue);
    }

    private void generateTheme() throws InterruptedException {
        IStyle importedTheme;
        this.checkInterrupted();
        if (this.theme != null && (importedTheme = this.getTargetWorkbook().getStyleSheet().importStyle(this.theme)) != null) {
            this.getTargetSheet().setThemeId(importedTheme.getId());
        }
    }

    private void recordTopicLink(String OId, ITopic sourceTopic) {
        List<ITopic> topics = this.topicLinkMap.get(OId);
        if (topics == null) {
            topics = new ArrayList<ITopic>();
            this.topicLinkMap.put(OId, topics);
        }
        topics.add(sourceTopic);
    }

    private void setTopicLinks() {
        for (Map.Entry<String, List<ITopic>> en : this.topicLinkMap.entrySet()) {
            String Oid = this.refIdMap.get(en.getKey());
            String id = this.topicIdMap.get(Oid);
            if (id == null) continue;
            for (ITopic topic : en.getValue()) {
                topic.setHyperlink(HyperlinkUtils.toInternalURL((String)id));
            }
        }
    }

    private String getResourceTitle(Element originEle) throws InterruptedException {
        this.checkInterrupted();
        Element resourceEle = this.findResourceEle(originEle);
        if (resourceEle == null) {
            return null;
        }
        return NovaMindImporter.att(resourceEle, "original-filename");
    }

    private IFileEntry getResourceFileEntry(Element originEle) throws InterruptedException {
        this.checkInterrupted();
        Element resourceEle = this.findResourceEle(originEle);
        if (resourceEle == null) {
            return null;
        }
        String url = NovaMindImporter.att(resourceEle, "url");
        String name = NovaMindImporter.att(resourceEle, "original-filename");
        if (url != null && !"".equals(url)) {
            return this.loadAttachment(String.valueOf(RESOURCES_FOLDER) + url, name);
        }
        return null;
    }

    private Element findResourceEle(Element originEle) throws InterruptedException {
        this.checkInterrupted();
        if (originEle == null) {
            return null;
        }
        String resourceRef = NovaMindImporter.att(originEle, "resource-ref");
        if (resourceRef == null || "".equals(resourceRef)) {
            return null;
        }
        Element resourceEle = this.resourceRefMap.get(resourceRef);
        if (resourceEle != null) {
            return resourceEle;
        }
        Element resourcesEle = NovaMindImporter.child(this.manifest.getDocumentElement(), "resources");
        if (resourcesEle == null) {
            return null;
        }
        Iterator<Element> it = NovaMindImporter.children(resourcesEle, "resource");
        while (it.hasNext()) {
            Element next = it.next();
            if (!resourceRef.equals(NovaMindImporter.att(next, "id"))) continue;
            this.resourceRefMap.put(resourceRef, next);
            return next;
        }
        return null;
    }

    private IFileEntry loadAttachment(String url, String proposalName) throws InterruptedException {
        String path;
        block14: {
            this.checkInterrupted();
            if (this.resourceMap.containsKey(url)) {
                String path2 = this.resourceMap.get(url);
                return path2 == null ? null : this.getTargetWorkbook().getManifest().getFileEntry(path2);
            }
            InputStream nmEntryStream = this.tempSource.getEntryStream(url);
            if (nmEntryStream == null) {
                return null;
            }
            if (proposalName != null && proposalName.startsWith("*.")) {
                String ext = proposalName.substring(1);
                String oldName = new File(url).getName();
                proposalName = String.valueOf(FileUtils.getNoExtensionFileName((String)oldName)) + ext;
            }
            MonitoredInputStream in = new MonitoredInputStream(nmEntryStream, this.getMonitor());
            path = null;
            try {
                try {
                    IFileEntry entry = this.getTargetWorkbook().getManifest().createAttachmentFromStream((InputStream)in, proposalName);
                    path = entry.getPath();
                }
                catch (Exception e) {
                    this.log(e, "Failed to create attachment from: " + url);
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.resourceMap.put(url, path);
        return this.getTargetWorkbook().getManifest().getFileEntry(path);
    }

    private static ITopicExtensionElement ensureTaskContent(ITopic topic, ITopicExtensionElement taskContent) {
        if (taskContent != null) {
            return taskContent;
        }
        ITopicExtension ext = topic.createExtension("org.xmind.ui.taskInfo");
        return ext.getContent();
    }

    private Element findThemeEle(String themeRef) throws InterruptedException {
        this.checkInterrupted();
        if (themeRef == null || "".equals(themeRef)) {
            return null;
        }
        Element themeEle = this.themeRefMap.get(themeRef);
        if (themeEle != null) {
            return themeEle;
        }
        if (this.styleSheet == null) {
            return null;
        }
        Element styleSheetEle = this.styleSheet.getDocumentElement();
        if (styleSheetEle == null) {
            return null;
        }
        Element themesEle = NovaMindImporter.child(styleSheetEle, "themes");
        if (themesEle == null) {
            return null;
        }
        Iterator<Element> it = NovaMindImporter.children(themesEle, "theme");
        while (it.hasNext()) {
            Element next = it.next();
            if (!themeRef.equals(NovaMindImporter.att(next, "id"))) continue;
            this.themeRefMap.put(themeRef, next);
            return next;
        }
        return null;
    }

    private String findAssign(String ref) throws InterruptedException {
        this.checkInterrupted();
        if (ref == null || "".equals(ref)) {
            return null;
        }
        String assign = this.assignRefMap.get(ref);
        if (assign != null) {
            return assign;
        }
        Element contentEle = this.content.getDocumentElement();
        Element resourcesEle = NovaMindImporter.child(contentEle, "project-resources");
        if (resourcesEle == null) {
            return null;
        }
        Iterator<Element> it = NovaMindImporter.children(resourcesEle, "project-resource");
        while (it.hasNext()) {
            Element next = it.next();
            if (!ref.equals(NovaMindImporter.att(next, "id"))) continue;
            String name = NovaMindImporter.att(next, "name");
            this.assignRefMap.put(ref, name);
            return name;
        }
        return null;
    }

    private static Element child(Element parentEle, String childTag) {
        return NovaMindImporter.children(parentEle, childTag).next();
    }

    private static Iterator<Element> children(Element parentEle, String childTag) {
        return new Iterator<Element>(childTag, parentEle){
            String tag;
            Iterator<Element> it;
            Element next;
            {
                this.tag = DOMUtils.getLocalName((String)string);
                this.it = DOMUtils.childElementIter((Node)element);
                this.next = this.findNext();
            }

            @Override
            public void remove() {
            }

            private Element findNext() {
                while (this.it.hasNext()) {
                    Element ele = this.it.next();
                    if (!DOMUtils.getLocalName((String)ele.getTagName()).equalsIgnoreCase(this.tag)) continue;
                    return ele;
                }
                return null;
            }

            @Override
            public Element next() {
                Element result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    private static String att(Element ele, String attName) {
        if (ele.hasAttribute(attName)) {
            return ele.getAttribute(attName);
        }
        attName = DOMUtils.getLocalName((String)attName);
        NamedNodeMap atts = ele.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            if (attName.equalsIgnoreCase(DOMUtils.getLocalName((String)att.getNodeName()))) {
                return att.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private static int mm2Dots(float mm) {
        return (int)((double)mm * 1.0);
    }

    private static String getMapping(String type, String sourceId, String defaultId) {
        String destination;
        if (sourceId != null && (destination = NovaMindImporter.getMappings().getDestination(type, sourceId)) != null) {
            return destination;
        }
        return defaultId;
    }

    private static ResourceMappingManager getMappings() {
        if (mappings == null) {
            mappings = NovaMindImporter.createMappings();
        }
        return mappings;
    }

    private static ResourceMappingManager createMappings() {
        return NovaMindResourceMappingManager.getInstance();
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DOMUtils.getDefaultDocumentBuilder();
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    private class NotesImporter {
        IParagraph currentParagraph = null;
        IHtmlNotesContent content;

        public NotesImporter(IHtmlNotesContent content) {
            this.content = content;
        }

        public void loadFrom(Element notesEle) throws InterruptedException {
            NovaMindImporter.this.checkInterrupted();
            Element richTextEle = NovaMindImporter.child(notesEle, "rich-text");
            if (richTextEle == null) {
                return;
            }
            NodeList nl = richTextEle.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                String nodeName = node.getNodeName();
                if ("text-run".equals(nodeName)) {
                    this.loadText(node);
                } else if ("hyperlink".equals(nodeName)) {
                    NamedNodeMap atts = node.getAttributes();
                    Node href = atts.getNamedItem("url");
                    IHyperlinkSpan linkSpan = this.content.createHyperlinkSpan(href.getTextContent());
                    this.addSpan(node, (ISpan)linkSpan);
                    NodeList hnl = node.getChildNodes();
                    int j = 0;
                    while (j < hnl.getLength()) {
                        Node hNode = hnl.item(j);
                        if (hNode != null && "text-run".equals(hNode.getNodeName())) {
                            this.loadText(hNode);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private void loadText(Node node) throws InterruptedException {
            NodeList ps = node.getChildNodes();
            int pi = 0;
            while (pi < ps.getLength()) {
                Node p = ps.item(pi);
                if (p.getNodeType() == 3) {
                    this.addText(node, p.getTextContent());
                } else if ("p".equals(p.getNodeName())) {
                    this.addParagraph(node);
                }
                ++pi;
            }
        }

        private void addText(Node node, String text) throws InterruptedException {
            if (text == null || "".equals(text)) {
                return;
            }
            this.addSpan(node, (ISpan)this.content.createTextSpan(text));
        }

        private void addSpan(Node node, ISpan span) throws InterruptedException {
            if (this.currentParagraph == null) {
                this.addParagraph(node);
            }
            this.currentParagraph.addSpan(span);
            this.loadStyle(node, (IStyled)span);
            this.loadAlign(node, (IStyled)this.currentParagraph);
        }

        private void addParagraph(Node node) throws InterruptedException {
            this.currentParagraph = this.content.createParagraph();
            this.content.addParagraph(this.currentParagraph);
            this.loadAlign(node, (IStyled)this.currentParagraph);
        }

        private void loadStyle(Node node, IStyled host) throws InterruptedException {
            Node windowsFontNameNode;
            Node italicNode;
            Node boldNode;
            Node fontSizeNode;
            NovaMindImporter.this.checkInterrupted();
            NamedNodeMap atts = node.getAttributes();
            Node nmColorNode = atts.getNamedItem("font-color");
            if (nmColorNode != null) {
                String nmColor = nmColorNode.getTextContent();
                nmColor = NovaMindImporter.this.realNmColor(nmColor);
                NovaMindImporter.this.registerStyle(host, "fo:color", NovaMindImporter.parseColor(nmColor.substring(3)));
            }
            if ((fontSizeNode = atts.getNamedItem("font-size")) != null) {
                NovaMindImporter.this.registerStyle(host, "fo:font-size", NovaMindImporter.parseFontSize(fontSizeNode.getTextContent()));
            }
            if ((boldNode = atts.getNamedItem("bold")) != null) {
                NovaMindImporter.this.registerStyle(host, "fo:font-weight", Boolean.parseBoolean(boldNode.getTextContent()) ? "bold" : null);
            }
            if ((italicNode = atts.getNamedItem("italic")) != null) {
                NovaMindImporter.this.registerStyle(host, "fo:font-style", Boolean.parseBoolean(italicNode.getTextContent()) ? "italic" : null);
            }
            String textDecoration = StyleUtils.toTextDecoration((atts.getNamedItem("underline-style") != null ? 1 : 0) != 0, (atts.getNamedItem("strikethrough-style") != null ? 1 : 0) != 0);
            NovaMindImporter.this.registerStyle(host, "fo:text-decoration", textDecoration);
            String fontName = null;
            Node macFontNameNode = atts.getNamedItem("mac-font-name");
            if (macFontNameNode != null) {
                fontName = macFontNameNode.getTextContent();
            }
            if ((fontName == null || "".equals(fontName)) && (windowsFontNameNode = atts.getNamedItem("windows-font-name")) != null) {
                fontName = windowsFontNameNode.getTextContent();
            }
            if (fontName != null) {
                String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
                fontName = availableFontName != null ? availableFontName : fontName;
                NovaMindImporter.this.registerStyle(host, "fo:font-family", fontName);
            }
        }

        private void loadAlign(Node node, IStyled host) throws InterruptedException {
            NovaMindImporter.this.checkInterrupted();
            NamedNodeMap atts = node.getAttributes();
            Node alignmentNode = atts.getNamedItem("alignment");
            if (alignmentNode != null) {
                NovaMindImporter.this.registerStyle(host, "fo:text-align", alignmentNode.getTextContent().toLowerCase());
            }
        }
    }
}

