/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.viewers.IListLayout;
import org.xmind.ui.viewers.IListRenderer;

public class MListViewer
extends StructuredViewer {
    private Composite composite;
    private Listener eventListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 13) {
                MListViewer.this.handleItemSelect(event);
            } else if (event.type == 14) {
                MListViewer.this.handleOpen(new SelectionEvent(event));
            } else if (event.type == 3) {
                MListViewer.this.handleMouseDown(event);
            } else if (event.type == 1) {
                MListViewer.this.handleKeyDown(event);
            } else if (event.type == 31) {
                MListViewer.this.handleKeyTraversed(event);
            }
        }
    };
    private int keyDownSelectionEventId = 0;

    public MListViewer(Composite parent, int style) {
        this.composite = new Composite(parent, style);
        this.composite.setLayout((Layout)new MListLayout());
        this.composite.addListener(13, this.eventListener);
        this.composite.addListener(14, this.eventListener);
        this.composite.addListener(3, this.eventListener);
        this.composite.addListener(1, this.eventListener);
        this.composite.addListener(31, this.eventListener);
        this.hookControl((Control)this.composite);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof IListRenderer));
        super.setLabelProvider(labelProvider);
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Control[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Control item = items[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof Control) {
            Control item = (Control)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IListRenderer renderer = (IListRenderer)this.getLabelProvider();
            if (renderer != null) {
                renderer.updateListItem(this, element, item);
            }
            if (item.isDisposed()) {
                this.unmapElement(element, (Widget)item);
            }
        }
    }

    protected List getSelectionFromWidget() {
        ArrayList<Object> list = new ArrayList<Object>();
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        if (renderer == null) {
            return list;
        }
        Control[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Object e;
            Control item = items[i];
            int state = renderer.getListItemState(this, item);
            if ((state & 1) != 0 && (e = item.getData()) != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    protected void internalRefresh(Object element) {
        if (element == null || this.equals(element, this.getRoot())) {
            this.internalRefreshAll(element);
        } else {
            Widget item = this.findItem(element);
            if (item != null) {
                this.updateItem(item, element);
            }
        }
    }

    private void internalRefreshAll(Object inputElement) {
        Control item;
        Object[] elements = this.getSortedChildren(inputElement);
        ArrayList<Control> items = new ArrayList<Control>(Arrays.asList(this.getItems()));
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            int itemIndex = -1;
            int j = i;
            while (j < items.size()) {
                item = (Control)items.get(j);
                if (this.equals(element, item.getData())) {
                    itemIndex = j;
                    break;
                }
                ++j;
            }
            if (itemIndex < 0) {
                item = this.createItem(element);
                Assert.isTrue((item != null && !item.isDisposed() ? 1 : 0) != 0);
                items.add(i, item);
                if (i == 0) {
                    item.moveAbove(null);
                } else {
                    item.moveBelow((Control)items.get(i - 1));
                }
            } else {
                item = (Control)items.get(itemIndex);
                if (itemIndex > i) {
                    if (i == 0) {
                        item.moveAbove(null);
                    } else {
                        item.moveBelow((Control)items.get(i - 1));
                    }
                    items.remove(itemIndex);
                    items.add(i, item);
                }
            }
            IListRenderer renderer = (IListRenderer)this.getLabelProvider();
            if (renderer != null) {
                renderer.updateListItem(this, element, item);
            }
            ++i;
        }
        while (i < items.size()) {
            item = (Control)items.get(i);
            this.disassociate(item);
            IListLayout layout = this.getListLayout();
            if (layout != null) {
                layout.itemRemoved(this, this.composite, item);
            }
            item.dispose();
            ++i;
        }
        this.composite.layout(true);
    }

    private Control createItem(Object element) {
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        Object item = renderer != null ? renderer.createListItemForElement(this, this.composite, element) : new Composite(this.composite, 0);
        IListLayout layout = this.getListLayout();
        if (layout != null) {
            layout.itemAdded(this, this.composite, (Control)item);
        }
        this.associate(element, (Control)item);
        return item;
    }

    private IListLayout getListLayout() {
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        return renderer.getListLayout(this);
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        if (renderer == null) {
            return;
        }
        ArrayList elementsToSelect = new ArrayList(list);
        Control[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Control item = items[i];
            Object data = item.getData();
            int elementIndex = -1;
            if (data != null) {
                int j = 0;
                while (j < elementsToSelect.size()) {
                    if (this.equals(data, elementsToSelect.get(j))) {
                        elementIndex = j;
                    }
                    ++j;
                }
            }
            int state = renderer.getListItemState(this, item);
            if (elementIndex < 0) {
                state &= 0xFFFFFFFE;
            } else {
                state |= 1;
                elementsToSelect.remove(elementIndex);
            }
            renderer.setListItemState(this, item, state);
            ++i;
        }
    }

    public Control getControl() {
        return this.composite;
    }

    protected void associate(Object element, Control item) {
        Object data = item.getData();
        if (data != element) {
            if (data != null) {
                this.disassociate(item);
            }
            item.setData(element);
            this.mapElement(element, (Widget)item);
        } else {
            this.mapElement(element, (Widget)item);
        }
    }

    protected void disassociate(Control item) {
        Object element = item.getData();
        Assert.isNotNull((Object)element);
        this.unmapElement(element, (Widget)item);
        item.setData(null);
    }

    public Object getElementAt(int index) {
        Control[] items = this.getItems();
        if (index >= 0 && index < items.length) {
            return items[index].getData();
        }
        return null;
    }

    protected Control[] getItems() {
        return this.composite.getChildren();
    }

    protected void inputChanged(final Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                Control control = MListViewer.this.getControl();
                control.setRedraw(false);
                try {
                    MListViewer.this.internalRefreshAll(input);
                }
                finally {
                    control.setRedraw(true);
                }
            }
        });
    }

    private void handleItemSelect(final Event event) {
        this.handleSelect(new SelectionEvent(event));
        if (event.detail == 0x1000002 || event.detail == 0x1000001 || event.detail == 0x1000003 || event.detail == 0x1000004) {
            ++this.keyDownSelectionEventId;
            final int id = this.keyDownSelectionEventId;
            Display.getCurrent().timerExec(OpenStrategy.getPostSelectionDelay(), new Runnable(){

                @Override
                public void run() {
                    if (id != MListViewer.this.keyDownSelectionEventId) {
                        return;
                    }
                    MListViewer.this.handlePostSelect(new SelectionEvent(event));
                }
            });
        } else {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MListViewer.this.handlePostSelect(new SelectionEvent(event));
                }
            });
        }
    }

    private void handleMouseDown(Event event) {
        this.getControl().setFocus();
    }

    private void handleKeyTraversed(Event event) {
        switch (event.detail) {
            case 64: {
                this.selectNextItem();
                event.doit = false;
                return;
            }
            case 32: {
                this.selectPreviousItem();
                event.doit = false;
                return;
            }
            case 4: 
            case 256: 
            case 512: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    private void handleKeyDown(Event event) {
        if (event.character == '\r') {
            this.handleOpen(new SelectionEvent(event));
        }
    }

    private void selectNextItem() {
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        if (renderer == null) {
            return;
        }
        Control[] items = this.getItems();
        if (items.length == 0) {
            return;
        }
        Control nextItem = null;
        int i = items.length - 1;
        while (i >= 0) {
            Control item = items[i];
            int state = renderer.getListItemState(this, item);
            if ((state & 1) != 0) break;
            nextItem = item;
            --i;
        }
        if (nextItem == null) {
            nextItem = items[items.length - 1];
        }
        this.selectSingle(renderer, items, nextItem);
    }

    private void selectPreviousItem() {
        IListRenderer renderer = (IListRenderer)this.getLabelProvider();
        if (renderer == null) {
            return;
        }
        Control[] items = this.getItems();
        if (items.length == 0) {
            return;
        }
        Control prevItem = null;
        int i = 0;
        while (i < items.length) {
            Control item = items[i];
            int state = renderer.getListItemState(this, item);
            if ((state & 1) != 0) break;
            prevItem = item;
            ++i;
        }
        if (prevItem == null) {
            prevItem = items[0];
        }
        this.selectSingle(renderer, items, prevItem);
    }

    private void selectSingle(IListRenderer renderer, Control[] items, Control itemToSelect) {
        int i = 0;
        while (i < items.length) {
            Control item = items[i];
            int state = renderer.getListItemState(this, item);
            state = item != itemToSelect ? (state &= 0xFFFFFFFE) : (state |= 1);
            renderer.setListItemState(this, item, state);
            ++i;
        }
    }

    private class MListLayout
    extends Layout {
        private MListLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            IListLayout layout = MListViewer.this.getListLayout();
            if (layout != null) {
                return layout.computeSize(MListViewer.this, composite, wHint, hHint, flushCache);
            }
            return new Point(0, 0);
        }

        protected void layout(Composite composite, boolean flushCache) {
            IListLayout layout = MListViewer.this.getListLayout();
            if (layout != null) {
                layout.layout(MListViewer.this, composite, flushCache);
            }
        }
    }
}

