/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.viewers.ILabelDescriptor;

public class CachedLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private ILabelDescriptor labelDescriptor;
    private Map<Object, Image> images = new HashMap<Object, Image>();
    private Map<Object, Color> foregroundColors = new HashMap<Object, Color>();
    private Map<Object, Color> backgroundColors = new HashMap<Object, Color>();
    private Map<Object, Font> fonts = new HashMap<Object, Font>();

    public CachedLabelProvider(ILabelDescriptor labelDescriptor) {
        this.labelDescriptor = labelDescriptor;
    }

    public String getText(Object element) {
        if (this.labelDescriptor == null) {
            return this.getDefaultText(element);
        }
        return this.labelDescriptor.getText(element);
    }

    protected String getDefaultText(Object element) {
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (this.labelDescriptor == null) {
            return this.getDefaultImage(element);
        }
        Image image = this.images.get(element);
        if (image == null || image.isDisposed()) {
            ImageDescriptor imageDescriptor = this.labelDescriptor.getImage(element);
            image = imageDescriptor == null ? null : imageDescriptor.createImage(false, (Device)Display.getCurrent());
            this.images.put(element, image);
        }
        return image;
    }

    protected Image getDefaultImage(Object element) {
        return super.getImage(element);
    }

    public Font getFont(Object element) {
        if (this.labelDescriptor == null) {
            return this.getDefaultFont(element);
        }
        Font font = this.fonts.get(element);
        if (font == null || font.isDisposed()) {
            FontDescriptor fontDescriptor = this.labelDescriptor.getFont(element);
            font = fontDescriptor == null ? null : fontDescriptor.createFont((Device)Display.getCurrent());
            this.fonts.put(element, font);
        }
        return font;
    }

    protected Font getDefaultFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (this.labelDescriptor == null) {
            return this.getDefaultForeground(element);
        }
        Color color = this.foregroundColors.get(element);
        if (color == null || color.isDisposed()) {
            ColorDescriptor colorDescriptor = this.labelDescriptor.getForeground(element);
            color = colorDescriptor == null ? null : colorDescriptor.createColor((Device)Display.getCurrent());
            this.foregroundColors.put(element, color);
        }
        return color;
    }

    protected Color getDefaultForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (this.labelDescriptor == null) {
            return this.getDefaultBackground(element);
        }
        Color color = this.backgroundColors.get(element);
        if (color == null || color.isDisposed()) {
            ColorDescriptor colorDescriptor = this.labelDescriptor.getBackground(element);
            color = colorDescriptor == null ? null : colorDescriptor.createColor((Device)Display.getCurrent());
            this.backgroundColors.put(element, color);
        }
        return color;
    }

    protected Color getDefaultBackground(Object element) {
        return null;
    }

    public void dispose() {
        Object[] cachedImages = this.images.values().toArray();
        Object[] cachedForegroundColors = this.foregroundColors.values().toArray();
        Object[] cachedBackgroundColors = this.backgroundColors.values().toArray();
        Object[] cachedFonts = this.fonts.values().toArray();
        this.images.clear();
        this.foregroundColors.clear();
        this.backgroundColors.clear();
        this.fonts.clear();
        CachedLabelProvider.disposeResources(cachedImages);
        CachedLabelProvider.disposeResources(cachedForegroundColors);
        CachedLabelProvider.disposeResources(cachedBackgroundColors);
        CachedLabelProvider.disposeResources(cachedFonts);
        super.dispose();
    }

    private static void disposeResources(Object[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                ((Resource)resources[i]).dispose();
            }
            ++i;
        }
    }
}

