/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.statushandlers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.xmind.ui.internal.statushandlers.DefaultErrorReporter;
import org.xmind.ui.internal.statushandlers.IErrorReporter;
import org.xmind.ui.internal.statushandlers.StatusDetails;
import org.xmind.ui.internal.statushandlers.StatusHandlerMessages;

public class RuntimeErrorDialog
extends Dialog {
    public static final int NONE = 0;
    public static final int BLOCKED = 1;
    private StatusDetails details;
    private String dialogTitle;
    private IErrorReporter reporter;
    private Control detailsArea = null;

    public RuntimeErrorDialog(int style, StatusAdapter statusAdapter, String dialogTitle, IErrorReporter reporter) {
        super(Display.getDefault().getActiveShell());
        this.details = new StatusDetails(statusAdapter);
        this.dialogTitle = dialogTitle;
        this.reporter = reporter == null ? DefaultErrorReporter.getInstance() : reporter;
        this.setBlockOnOpen(false);
        if ((style & 1) != 0) {
            this.setShellStyle(this.getShellStyle() | 0x10000);
        } else {
            this.setShellStyle(0xFFFEFFFF & this.getShellStyle());
        }
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        if (this.dialogTitle != null) {
            shell.setText(this.dialogTitle);
        } else {
            shell.setText(StatusHandlerMessages.RuntimeErrorDialog_windowTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Control titleArea = this.createTitleArea(composite);
        titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)titleArea.getLayoutData()).widthHint = 280;
        this.detailsArea = this.createDetailsArea(composite);
        this.detailsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)this.detailsArea.getLayoutData()).widthHint = 300;
        ((GridData)this.detailsArea.getLayoutData()).heightHint = 150;
        return composite;
    }

    private Control createTitleArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        area.setLayout((Layout)layout);
        Label titleImageLabel = new Label(area, 0);
        titleImageLabel.setImage(this.details.getImage());
        titleImageLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite messageParent = new Composite(area, 0);
        messageParent.setLayout((Layout)new GridLayout());
        Label messageLabel = new Label(messageParent, 64);
        messageLabel.setText(this.details.getMessage());
        messageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        return area;
    }

    private Control createDetailsArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        area.setLayout((Layout)layout);
        Text detailsText = new Text(area, 2818);
        detailsText.setEditable(false);
        detailsText.setText(this.details.getFullText());
        detailsText.setLayoutData((Object)new GridData(4, 4, true, true));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)parent.getLayout()).horizontalSpacing = 250;
        Hyperlink report = new Hyperlink(parent, 16384);
        report.setText(StatusHandlerMessages.RuntimeErrorDialog_ReportHyperlink_Text);
        report.setUnderlined(true);
        report.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                RuntimeErrorDialog.this.reportPressed();
            }
        });
        this.createButton(parent, 1, StatusHandlerMessages.RuntimeErrorDialog_CloseButton_Text, false);
    }

    private void reportPressed() {
        try {
            this.reporter.report(this.details);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.close();
    }
}

